<?php
/**
 * Update venue capacities
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🏢 Update Venue Capacities</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
</style>';

global $wpdb;

try {
    // Define venue capacities
    $venue_capacities = [
        'Cite Aldgate' => 250,
        'Haus Stratford' => 280,
        'TWNTY7 Nightclub' => 220
    ];
    
    echo '<h2>📊 Updating Venue Capacities</h2>';
    
    $table_features = $wpdb->prefix . 'coco_event_features';
    $updated_count = 0;
    
    foreach ($venue_capacities as $venue_name => $capacity) {
        echo '<p>Updating <strong>' . $venue_name . '</strong> to capacity ' . $capacity . '</p>';
        
        // Find events at this venue
        $events = $wpdb->get_results($wpdb->prepare("
            SELECT ef.event_id, ef.venue_id, p.post_title as venue_name
            FROM $table_features ef
            INNER JOIN {$wpdb->posts} p ON ef.venue_id = p.ID
            WHERE p.post_title = %s
        ", $venue_name));
        
        if ($events) {
            foreach ($events as $event) {
                $result = $wpdb->update(
                    $table_features,
                    ['capacity' => $capacity],
                    ['event_id' => $event->event_id],
                    ['%d'],
                    ['%d']
                );
                
                if ($result !== false) {
                    $updated_count++;
                    echo '<p class="success">✅ Updated event ' . $event->event_id . ' at ' . $venue_name . '</p>';
                } else {
                    echo '<p class="error">❌ Failed to update event ' . $event->event_id . '</p>';
                }
            }
        } else {
            echo '<p class="info">ℹ️ No events found for venue: ' . $venue_name . '</p>';
        }
    }
    
    echo '<h2>📊 Summary</h2>';
    echo '<p class="success">✅ Updated ' . $updated_count . ' events with new capacities</p>';
    
    // Show current capacities
    echo '<h2>🏢 Current Venue Capacities</h2>';
    $capacities = $wpdb->get_results("
        SELECT p.post_title as venue_name, ef.capacity, COUNT(ef.event_id) as event_count
        FROM $table_features ef
        INNER JOIN {$wpdb->posts} p ON ef.venue_id = p.ID
        GROUP BY ef.venue_id, p.post_title, ef.capacity
        ORDER BY p.post_title
    ");
    
    if ($capacities) {
        echo '<table border="1" cellpadding="10" cellspacing="0" style="border-collapse: collapse;">';
        echo '<tr><th>Venue</th><th>Capacity</th><th>Events</th></tr>';
        foreach ($capacities as $cap) {
            echo '<tr>';
            echo '<td>' . esc_html($cap->venue_name) . '</td>';
            echo '<td>' . $cap->capacity . '</td>';
            echo '<td>' . $cap->event_count . '</td>';
            echo '</tr>';
        }
        echo '</table>';
    }
    
} catch (Exception $e) {
    echo '<p class="error">❌ Error: ' . $e->getMessage() . '</p>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}

echo '<hr>';
echo '<p><strong>🚀 Next Steps:</strong></p>';
echo '<ol>';
echo '<li>Go to Events page and check if capacities are now correct</li>';
echo '<li>Cite Aldgate should show 250</li>';
echo '<li>Haus Stratford should show 280</li>';
echo '<li>TWNTY7 Nightclub should show 220</li>';
echo '</ol>';
?>
