<?php
// Test time bucket matching
require_once('../../../wp-config.php');

echo "🧪 TESTING TIME BUCKET MATCHING\n";
echo str_repeat("=", 50) . "\n\n";

global $wpdb;

// Test different time buckets
$test_buckets = ['late_night', 'night', 'evening', 'afternoon', 'morning'];

foreach ($test_buckets as $bucket) {
    echo "Testing time bucket: $bucket\n";
    
    // Use same logic as cohort matcher
    $time_buckets = [];
    switch ($bucket) {
        case 'late_night':
            $time_buckets = ['late_night', 'night'];
            break;
        case 'night':
            $time_buckets = ['night', 'late_night'];
            break;
        case 'evening':
            $time_buckets = ['evening', 'night'];
            break;
        case 'afternoon':
            $time_buckets = ['afternoon', 'evening'];
            break;
        case 'morning':
            $time_buckets = ['morning', 'afternoon'];
            break;
        default:
            $time_buckets = [$bucket];
    }
    
    echo "  Matches: " . implode(', ', $time_buckets) . "\n";
    
    // Count events for each time bucket
    foreach ($time_buckets as $tb) {
        $count = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_features 
            WHERE start_bucket = %s AND start_ts < NOW()
        ", $tb));
        echo "    $tb: $count events\n";
    }
    echo "\n";
}

echo "✅ Time bucket matching test complete.\n";
?>
