<?php
// Test snapshot creation logic for finished vs future events
require_once('../../../wp-config.php');

echo "🧪 Testing Snapshot Creation Logic\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Test with event 250474 (finished event)
$finished_event_id = 250474;
$finished_start = get_post_meta($finished_event_id, '_EventStartDate', true);
$finished_dt = new DateTime($finished_start);
$now_dt = new DateTime();

echo "1️⃣ Finished Event Test (ID: $finished_event_id):\n";
echo "Event start: $finished_start\n";
echo "Current time: " . $now_dt->format('Y-m-d H:i:s') . "\n";
echo "Event finished: " . ($finished_dt <= $now_dt ? 'Yes' : 'No') . "\n";
echo "Should create fresh snapshot: " . ($finished_dt > $now_dt ? 'Yes' : 'No') . "\n\n";

// Test with a future event (if any exist)
$future_event = $wpdb->get_row("
    SELECT p.ID, pm.meta_value as start_date
    FROM {$wpdb->posts} p
    LEFT JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_EventStartDate'
    WHERE p.post_type = 'tribe_events'
    AND p.post_status = 'publish'
    AND pm.meta_value > NOW()
    ORDER BY pm.meta_value ASC
    LIMIT 1
");

if ($future_event) {
    echo "2️⃣ Future Event Test (ID: {$future_event->ID}):\n";
    echo "Event start: {$future_event->start_date}\n";
    echo "Current time: " . $now_dt->format('Y-m-d H:i:s') . "\n";
    $future_dt = new DateTime($future_event->start_date);
    echo "Event finished: " . ($future_dt <= $now_dt ? 'Yes' : 'No') . "\n";
    echo "Should create fresh snapshot: " . ($future_dt > $now_dt ? 'Yes' : 'No') . "\n\n";
} else {
    echo "2️⃣ No future events found for testing\n\n";
}

// Test the forecasting engine logic
echo "3️⃣ Testing Forecasting Engine Logic:\n";
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    
    // Test with finished event
    echo "Testing with finished event $finished_event_id:\n";
    $forecast = $forecasting_engine->generate_forecast($finished_event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "✅ Forecast generated successfully\n";
        echo "- Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "- Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "- Method: " . ($forecast['forecast']['method'] ?? 'N/A') . "\n";
        
        if (isset($forecast['current'])) {
            echo "- Current tickets: " . ($forecast['current']['tickets_sold'] ?? 'N/A') . "\n";
        }
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete.\n";
?>
