<?php
// Test script to create a sample report for testing
// Access via: yoursite.com/wp-content/plugins/coco-ops-forecast/test-sample-report.php

// Check if we're in WordPress context
if (!defined('ABSPATH')) {
    echo "This script must be run from within WordPress context.\n";
    echo "Please access it via: yoursite.com/wp-content/plugins/coco-ops-forecast/test-sample-report.php\n";
    exit;
}

global $wpdb;

echo "=== CREATING SAMPLE REPORT ===\n";

// Get a random event
$event = $wpdb->get_row("
    SELECT p.ID, p.post_title, pm_start.meta_value as start_date, pm_venue.meta_value as venue_id
    FROM {$wpdb->posts} p
    LEFT JOIN {$wpdb->postmeta} pm_start ON p.ID = pm_start.post_id AND pm_start.meta_key = '_EventStartDate'
    LEFT JOIN {$wpdb->postmeta} pm_venue ON p.ID = pm_venue.post_id AND pm_venue.meta_key = '_EventVenueID'
    WHERE p.post_type = 'tribe_events'
    AND p.post_status = 'publish'
    ORDER BY RAND()
    LIMIT 1
");

if (!$event) {
    echo "No events found.\n";
    exit;
}

echo "Using event: {$event->post_title} (ID: {$event->ID})\n";

// Create sample actuals data
$actuals_data = [
    'final_attendance' => 120,
    'final_revenue' => 3600.00,
    'actual_bartenders' => 2,
    'actual_bottle_girls' => 1,
    'actual_wait' => 1,
    'actual_security' => 2,
    'actual_managers' => 1,
    'notes' => 'Sample actuals for testing reports'
];

// Save actuals to database
$existing = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_actuals WHERE event_id = %d",
    $event->ID
));

if ($existing > 0) {
    $wpdb->update(
        $wpdb->prefix . 'coco_event_actuals',
        array_merge($actuals_data, [
            'entered_at' => current_time('mysql')
        ]),
        ['event_id' => $event->ID]
    );
    echo "Updated existing actuals.\n";
} else {
    $wpdb->insert(
        $wpdb->prefix . 'coco_event_actuals',
        array_merge($actuals_data, [
            'event_id' => $event->ID,
            'entered_at' => current_time('mysql')
        ])
    );
    echo "Created new actuals.\n";
}

// Generate report
echo "Generating report...\n";

try {
    $report_generator = new Coco_Ops_Post_Event_Report();
    $report = $report_generator->generate_report($event->ID, $actuals_data);
    
    if ($report) {
        echo "Report generated successfully!\n";
        echo "Report data:\n";
        echo "Event: {$report['event_title']}\n";
        echo "Attendance: {$report['actuals']['final_attendance']}\n";
        echo "Revenue: £{$report['actuals']['final_revenue']}\n";
        echo "Revenue per staff: £{$report['metrics']['revenue_per_staff']}\n";
        echo "Forecast accuracy: {$report['metrics']['attendance_accuracy']}%\n";
    } else {
        echo "Failed to generate report.\n";
    }
    
} catch (Exception $e) {
    echo "Error generating report: " . $e->getMessage() . "\n";
}

// Check reports table
$report_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_reports");
echo "\nTotal reports in database: $report_count\n";

if ($report_count > 0) {
    $latest_report = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}coco_event_reports ORDER BY generated_at DESC LIMIT 1");
    echo "Latest report data:\n";
    $report_data = json_decode($latest_report->report_data, true);
    echo "Event: {$report_data['event_title']}\n";
    echo "Actuals: " . json_encode($report_data['actuals']) . "\n";
    echo "Metrics: " . json_encode($report_data['metrics']) . "\n";
}

echo "\n=== TEST COMPLETE ===\n";
echo "You can now check the Reports dashboard to see the sample data.\n";
?>
