<?php
/**
 * Test rules engine directly
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🧪 Test Rules Engine</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
</style>';

try {
    // Test with 200 people on Saturday
    $attendance = 200;
    $event_features = [
        'weekday' => 'Saturday',
        'start_bucket' => 'evening'
    ];
    
    echo '<h2>Test: 200 people on Saturday</h2>';
    echo '<p>Attendance: ' . $attendance . '</p>';
    echo '<p>Weekday: ' . $event_features['weekday'] . '</p>';
    
    $rules_engine = new Coco_Ops_Rules_Engine();
    $result = $rules_engine->compute_staffing($attendance, $event_features);
    
    echo '<h3>Results:</h3>';
    echo '<pre>' . print_r($result, true) . '</pre>';
    
    // Test with 30 people on Tuesday
    echo '<hr>';
    echo '<h2>Test: 30 people on Tuesday (weekday substitution)</h2>';
    $attendance = 30;
    $event_features = [
        'weekday' => 'Tuesday',
        'start_bucket' => 'evening'
    ];
    
    echo '<p>Attendance: ' . $attendance . '</p>';
    echo '<p>Weekday: ' . $event_features['weekday'] . '</p>';
    
    $result2 = $rules_engine->compute_staffing($attendance, $event_features);
    
    echo '<h3>Results:</h3>';
    echo '<pre>' . print_r($result2, true) . '</pre>';
    
} catch (Exception $e) {
    echo '<p class="error">❌ Error: ' . $e->getMessage() . '</p>';
    echo '<p>Stack trace:</p>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}

echo '<hr>';
echo '<p>Done.</p>';
?>
