<?php
// Test script to create sample actuals and generate a report
// This should be run from WordPress admin or via wp-cli

// Check if we're in WordPress context
if (!defined('ABSPATH')) {
    echo "This script must be run from within WordPress context.\n";
    echo "Please access it via: yoursite.com/wp-content/plugins/coco-ops-forecast/test-reports.php\n";
    exit;
}

global $wpdb;

echo "=== TESTING REPORTS FUNCTIONALITY ===\n";

// Check if we have any events
$events = $wpdb->get_results("
    SELECT p.ID, p.post_title, pm_start.meta_value as start_date
    FROM {$wpdb->posts} p
    LEFT JOIN {$wpdb->postmeta} pm_start ON p.ID = pm_start.post_id AND pm_start.meta_key = '_EventStartDate'
    WHERE p.post_type = 'tribe_events'
    AND p.post_status = 'publish'
    ORDER BY pm_start.meta_value DESC
    LIMIT 5
");

echo "Found " . count($events) . " events\n";

if (empty($events)) {
    echo "No events found. Cannot test reports.\n";
    exit;
}

$test_event = $events[0];
echo "Using test event: {$test_event->post_title} (ID: {$test_event->ID})\n";

// Check if this event already has actuals
$existing_actuals = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_actuals WHERE event_id = %d",
    $test_event->ID
));

if ($existing_actuals > 0) {
    echo "Event already has actuals. Updating...\n";
    
    // Update existing actuals
    $wpdb->update(
        $wpdb->prefix . 'coco_event_actuals',
        [
            'final_attendance' => 150,
            'final_revenue' => 4500.00,
            'actual_bartenders' => 3,
            'actual_bottle_girls' => 2,
            'actual_wait' => 1,
            'actual_security' => 2,
            'actual_managers' => 1,
            'notes' => 'Test actuals for reports functionality',
            'entered_at' => current_time('mysql')
        ],
        ['event_id' => $test_event->ID]
    );
} else {
    echo "Creating test actuals...\n";
    
    // Create test actuals
    $wpdb->insert(
        $wpdb->prefix . 'coco_event_actuals',
        [
            'event_id' => $test_event->ID,
            'final_attendance' => 150,
            'final_revenue' => 4500.00,
            'actual_bartenders' => 3,
            'actual_bottle_girls' => 2,
            'actual_wait' => 1,
            'actual_security' => 2,
            'actual_managers' => 1,
            'notes' => 'Test actuals for reports functionality',
            'entered_at' => current_time('mysql')
        ]
    );
}

echo "Test actuals created/updated.\n";

// Now trigger report generation
echo "Generating report...\n";

try {
    $report_generator = new Coco_Ops_Post_Event_Report();
    $actuals_data = [
        'final_attendance' => 150,
        'final_revenue' => 4500.00,
        'actual_bartenders' => 3,
        'actual_bottle_girls' => 2,
        'actual_wait' => 1,
        'actual_security' => 2,
        'actual_managers' => 1,
        'notes' => 'Test actuals for reports functionality'
    ];
    
    $report = $report_generator->generate_report($test_event->ID, $actuals_data);
    
    if ($report) {
        echo "Report generated successfully!\n";
        echo "Report metrics:\n";
        print_r($report['metrics']);
    } else {
        echo "Failed to generate report.\n";
    }
    
} catch (Exception $e) {
    echo "Error generating report: " . $e->getMessage() . "\n";
}

// Check if report was created
$report_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_reports");
echo "Total reports in database: $report_count\n";

echo "\n=== TEST COMPLETE ===\n";
echo "You can now check the Reports dashboard to see the test data.\n";
?>
