<?php
// Test post-event snapshots generation
require_once('../../../wp-config.php');

echo "📸 Testing Post-Event Snapshots Generation\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

try {
    require_once('includes/class-snapshot-cron.php');
    $cron = new Coco_Ops_Snapshot_Cron();
    
    echo "Generating post-event snapshots...\n";
    $snapshots_created = $cron->generate_post_event_snapshots();
    
    echo "✅ Created $snapshots_created post-event snapshots\n";
    
    // Show some recent snapshots
    global $wpdb;
    $recent_snapshots = $wpdb->get_results("
        SELECT event_id, snapshot_ts, days_to_event, tickets_sold, tables_sold, revenue_to_date
        FROM {$wpdb->prefix}coco_event_snapshots
        WHERE days_to_event < 0
        ORDER BY snapshot_ts DESC
        LIMIT 10
    ");
    
    if ($recent_snapshots) {
        echo "\n📊 Recent Post-Event Snapshots:\n";
        foreach ($recent_snapshots as $snapshot) {
            echo "- Event $snapshot->event_id: D$snapshot->days_to_event, {$snapshot->tickets_sold} tix, {$snapshot->tables_sold} tables, £{$snapshot->revenue_to_date}\n";
        }
    } else {
        echo "\n❌ No post-event snapshots found\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete.\n";
?>
