<?php
/**
 * Test error logging
 */

// Include WordPress
require_once('../../../wp-config.php');

echo "<h2>🧪 Test Error Logging</h2>";

// Test different logging methods
error_log('CocoOpsHistorical: Test error log message');
echo "<p>1. error_log() called</p>";

// Test WordPress logging
if (function_exists('wp_debug_log')) {
    wp_debug_log('CocoOpsHistorical: Test wp_debug_log message');
    echo "<p>2. wp_debug_log() called</p>";
} else {
    echo "<p>2. wp_debug_log() not available</p>";
}

// Test file logging
$log_file = ABSPATH . 'wp-content/debug.log';
if (file_put_contents($log_file, "CocoOpsHistorical: Test file write at " . current_time('mysql') . "\n", FILE_APPEND)) {
    echo "<p>3. Direct file write to {$log_file} successful</p>";
} else {
    echo "<p>3. Direct file write failed</p>";
}

// Check if debug.log exists and is writable
if (file_exists($log_file)) {
    echo "<p>4. Debug log file exists: {$log_file}</p>";
    echo "<p>5. File size: " . filesize($log_file) . " bytes</p>";
    echo "<p>6. File writable: " . (is_writable($log_file) ? 'Yes' : 'No') . "</p>";
} else {
    echo "<p>4. Debug log file does not exist: {$log_file}</p>";
}

// Check WordPress debug settings
echo "<p>7. WP_DEBUG: " . (defined('WP_DEBUG') && WP_DEBUG ? 'True' : 'False') . "</p>";
echo "<p>8. WP_DEBUG_LOG: " . (defined('WP_DEBUG_LOG') && WP_DEBUG_LOG ? 'True' : 'False') . "</p>";

echo "<h3>Test Complete</h3>";
?>
