<?php
// Test fresh forecast with live data
require_once('../../../wp-config.php');

$event_id = 250474;

echo "🧪 Testing Fresh Forecast for Event $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check current event status
$event_start = get_post_meta($event_id, '_EventStartDate', true);
$start_dt = new DateTime($event_start);
$now_dt = new DateTime();
$days_diff = $start_dt->diff($now_dt)->days;
if ($start_dt < $now_dt) {
    $days_diff = -$days_diff; // Event is in the past
}

echo "Event Details:\n";
echo "Event start: $event_start\n";
echo "Current time: " . $now_dt->format('Y-m-d H:i:s') . "\n";
echo "Days difference: $days_diff\n";
echo "Is current event (within 14 days): " . (($days_diff >= -14 && $days_diff <= 14) ? 'Yes' : 'No') . "\n\n";

// Test the forecasting engine
echo "🤖 Testing Forecasting Engine:\n";
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "Generated forecast:\n";
        echo "- Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "- Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "- Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "- Method: " . ($forecast['forecast']['method'] ?? 'N/A') . "\n";
        
        if (isset($forecast['current'])) {
            echo "\nCurrent data used:\n";
            echo "- Tickets sold: " . ($forecast['current']['tickets_sold'] ?? 'N/A') . "\n";
            echo "- Tables sold: " . ($forecast['current']['tables_sold'] ?? 'N/A') . "\n";
            echo "- Revenue: £" . ($forecast['current']['revenue_to_date'] ?? 'N/A') . "\n";
            echo "- Days to event: " . ($forecast['current']['days_to_event'] ?? 'N/A') . "\n";
        }
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

// Check if a fresh snapshot was created (only for future events)
echo "\n📸 Checking for Fresh Snapshot:\n";
if ($start_dt > $now_dt) {
    echo "Event is in the future - checking for fresh snapshot...\n";
    $today = current_time('Y-m-d');
    $fresh_snapshot = $wpdb->get_row($wpdb->prepare("
        SELECT snapshot_ts, tickets_sold, tables_sold, revenue_to_date
        FROM {$wpdb->prefix}coco_event_snapshots
        WHERE event_id = %d AND DATE(snapshot_ts) = %s
        ORDER BY snapshot_ts DESC
        LIMIT 1
    ", $event_id, $today));

    if ($fresh_snapshot) {
        echo "✅ Fresh snapshot found:\n";
        echo "- Time: {$fresh_snapshot->snapshot_ts}\n";
        echo "- Tickets: {$fresh_snapshot->tickets_sold}\n";
        echo "- Tables: {$fresh_snapshot->tables_sold}\n";
        echo "- Revenue: £{$fresh_snapshot->revenue_to_date}\n";
    } else {
        echo "❌ No fresh snapshot found for today\n";
    }
} else {
    echo "Event has finished - no fresh snapshot created (as expected)\n";
}

echo "\n✅ Test complete.\n";
?>
