<?php
/**
 * Test Forecast API
 */

// Include WordPress
require_once('../../../wp-config.php');

global $wpdb;

echo "🧪 Testing Forecast API\n";
echo "Time: " . current_time('mysql') . "\n\n";

// Test with a specific event
$event_id = 256352; // TWNTY7 - 29 Nights (from your example)

echo "📅 Testing event ID: {$event_id}\n";

// Check if event features exist
$features = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}coco_event_features WHERE event_id = %d",
    $event_id
));

if (!$features) {
    echo "❌ No event features found for event {$event_id}\n";
    echo "🔍 Available events with features:\n";
    $available_events = $wpdb->get_results("
        SELECT event_id, weekday, start_bucket, venue_id 
        FROM {$wpdb->prefix}coco_event_features 
        LIMIT 10
    ");
    foreach ($available_events as $event) {
        echo "  - Event {$event->event_id}: {$event->weekday} {$event->start_bucket} (venue: {$event->venue_id})\n";
    }
    exit;
}

echo "✅ Event features found:\n";
echo "  - Venue: {$features->venue_id}\n";
echo "  - Weekday: {$features->weekday}\n";
echo "  - Start bucket: {$features->start_bucket}\n";
echo "  - Start time: {$features->start_ts}\n\n";

// Check if snapshots exist for this event
$snapshots = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_snapshots WHERE event_id = %d",
    $event_id
));

echo "📸 Snapshots for this event: {$snapshots}\n";

// Check total snapshots in database
$total_snapshots = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_snapshots");
echo "📊 Total snapshots in database: {$total_snapshots}\n\n";

// Test the forecasting engine directly
echo "🔮 Testing forecasting engine...\n";

try {
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    echo "✅ Forecast generated successfully!\n";
    echo "📊 Forecast data:\n";
    echo json_encode($forecast, JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo "❌ Forecast failed: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n🏁 Forecast test complete\n";
?>
