<?php
// Test the forecast rule fix
require_once('../../../wp-config.php');

$event_id = 250474; // Cite - Afrobeats Saturdays at Cococure Cite

echo "🧪 Testing Forecast Rule Fix\n";
echo "Event ID: $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Get live sales data to calculate minimum
$sales_data = $wpdb->get_results($wpdb->prepare("
    SELECT 
        oi.meta_value as ticket_price,
        oi2.meta_value as quantity,
        oi3.meta_value as line_total
    FROM {$wpdb->prefix}wc_orders o
    JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id AND oi.meta_key = '_tribe_wooticket_for_event'
    JOIN {$wpdb->prefix}wc_orders_meta oi2 ON o.id = oi2.order_id AND oi2.meta_key = '_qty'
    JOIN {$wpdb->prefix}wc_orders_meta oi3 ON o.id = oi3.order_id AND oi3.meta_key = '_line_total'
    WHERE oi.meta_value = %s
    AND o.status IN ('wc-completed', 'wc-processing')
", $event_id));

$paid_tickets = 0;
$free_tickets = 0;
$table_entries = 0;
$total_tickets = 0;
$table_threshold = 100;

echo "📊 Live Sales Analysis:\n";
echo "Found " . count($sales_data) . " sales records\n\n";

foreach ($sales_data as $sale) {
    $price = (float) $sale->ticket_price;
    $qty = (int) $sale->quantity;
    $line_total = (float) $sale->line_total;
    
    $total_tickets += $qty;
    
    if ($price >= $table_threshold) {
        $table_entries += $qty * 6; // Assuming 6 per table
        echo "Table: £$price x$qty = £$line_total → {$qty} tables = " . ($qty * 6) . " entries\n";
    } elseif ($line_total > 0) {
        $paid_tickets += $qty;
        echo "Paid: £$price x$qty = £$line_total\n";
    } else {
        $free_tickets += $qty;
        echo "Free: £$price x$qty = £$line_total\n";
    }
}

$minimum_forecast = $paid_tickets + $table_entries;

echo "\n📈 Summary:\n";
echo "Total tickets: $total_tickets\n";
echo "Paid tickets: $paid_tickets\n";
echo "Free tickets: $free_tickets\n";
echo "Table entries: $table_entries\n";
echo "Minimum forecast should be: $minimum_forecast\n\n";

// Test the forecasting engine
echo "🔮 Testing Forecasting Engine:\n";
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        $forecast_tickets = $forecast['forecast']['ticket_sales_p50'] ?? 0;
        $forecast_attendance = $forecast['forecast']['attendance_p50'] ?? 0;
        
        echo "Generated forecast:\n";
        echo "- Ticket sales p50: $forecast_tickets\n";
        echo "- Attendance p50: $forecast_attendance\n";
        echo "- Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "- Cohort count: " . ($forecast['forecast']['cohort_count'] ?? 'N/A') . "\n\n";
        
        echo "🔍 Rule Check:\n";
        if ($forecast_tickets >= $minimum_forecast) {
            echo "✅ SUCCESS: Forecast ($forecast_tickets) >= minimum ($minimum_forecast)\n";
        } else {
            echo "❌ FAILED: Forecast ($forecast_tickets) < minimum ($minimum_forecast)\n";
            echo "Expected forecast: $minimum_forecast\n";
        }
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete.\n";
?>
