<?php
// Test the forecast fixes
require_once('../../../wp-config.php');

$event_id = 256363; // The event from the error

echo "🧪 Testing Forecast Fix for Event $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    
    echo "🤖 Generating forecast...\n";
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "✅ Forecast generated successfully!\n";
        echo "Forecast data:\n";
        echo "- Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "- Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "- Revenue p50: £" . ($forecast['forecast']['revenue_p50'] ?? 'N/A') . "\n";
        echo "- Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "- Method: " . ($forecast['forecast']['method'] ?? 'N/A') . "\n";
        echo "- Cohort count: " . ($forecast['forecast']['cohort_count'] ?? 'N/A') . "\n";
        
        if (isset($forecast['current'])) {
            echo "\nCurrent data:\n";
            echo "- Tickets sold: " . ($forecast['current']['tickets_sold'] ?? 'N/A') . "\n";
            echo "- Tables sold: " . ($forecast['current']['tables_sold'] ?? 'N/A') . "\n";
            echo "- Revenue: £" . ($forecast['current']['revenue_to_date'] ?? 'N/A') . "\n";
            echo "- Days to event: " . ($forecast['current']['days_to_event'] ?? 'N/A') . "\n";
        }
    } else {
        echo "❌ Failed to generate forecast\n";
        if (isset($forecast['error'])) {
            echo "Error: " . $forecast['error'] . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
} catch (Error $e) {
    echo "❌ Fatal Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n✅ Test complete.\n";
?>