<?php
// Test forecast with debug logging
require_once('../../../wp-config.php');

$event_id = 250474; // Cite - Afrobeats Saturdays at Cococure Cite

echo "🧪 Testing Forecast with Debug Logging\n";
echo "Event ID: $event_id\n\n";

try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    
    echo "Generating forecast...\n";
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "\n📊 Forecast Results:\n";
        echo "Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "Revenue p50: £" . ($forecast['forecast']['revenue_p50'] ?? 'N/A') . "\n";
        echo "Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "Cohort count: " . ($forecast['forecast']['cohort_count'] ?? 'N/A') . "\n";
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete. Check error logs for detailed debug information.\n";
?>
