<?php
// Test D+1 snapshot forecasting
require_once('../../../wp-config.php');

$event_id = 250474; // Event we've been working with

echo "🧪 Testing D+1 Snapshot Forecasting for Event $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check if we have D+1 snapshots for this event
echo "1️⃣ Checking D+1 Snapshots for Event $event_id:\n";
$d1_snapshots = $wpdb->get_results($wpdb->prepare("
    SELECT snapshot_ts, days_to_event, tickets_sold, tables_sold, revenue_to_date
    FROM {$wpdb->prefix}coco_event_snapshots
    WHERE event_id = %d
    AND days_to_event < 0
    AND days_to_event >= -1
    ORDER BY snapshot_ts DESC
", $event_id));

if ($d1_snapshots) {
    echo "✅ Found " . count($d1_snapshots) . " D+1 snapshots:\n";
    foreach ($d1_snapshots as $snapshot) {
        echo "- {$snapshot->snapshot_ts}: D{$snapshot->days_to_event}, {$snapshot->tickets_sold} tix, £{$snapshot->revenue_to_date}\n";
    }
} else {
    echo "❌ No D+1 snapshots found\n";
}

// Test the forecasting engine
echo "\n2️⃣ Testing Forecasting Engine with D+1 Logic:\n";
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    
    // Use reflection to test the private method
    $reflection = new ReflectionClass($forecasting_engine);
    $get_cohort_final_method = $reflection->getMethod('get_cohort_final_ticket_sales');
    $get_cohort_final_method->setAccessible(true);
    
    // Get cohort IDs for this event
    $event_features = $wpdb->get_row($wpdb->prepare("
        SELECT venue_id, weekday, time_bucket
        FROM {$wpdb->prefix}coco_event_features
        WHERE event_id = %d
    ", $event_id));
    
    if ($event_features) {
        $cohorts = $wpdb->get_results($wpdb->prepare("
            SELECT ef.event_id
            FROM {$wpdb->prefix}coco_event_features ef
            WHERE ef.venue_id = %d
            AND ef.weekday = %s
            AND ef.time_bucket = %s
            AND ef.event_id != %d
            ORDER BY ef.start_ts DESC
            LIMIT 10
        ", $event_features->venue_id, $event_features->weekday, $event_features->time_bucket, $event_id));
        
        $cohort_ids = array_column($cohorts, 'event_id');
        echo "Testing with " . count($cohort_ids) . " cohort events\n";
        
        // Test the D+1 logic
        $final_sales = $get_cohort_final_method->invoke($forecasting_engine, $cohort_ids);
        
        echo "Final sales data retrieved for " . count($final_sales) . " events:\n";
        foreach ($final_sales as $event_id => $tickets) {
            echo "- Event $event_id: $tickets tickets\n";
        }
    }
    
    // Test full forecast
    echo "\n3️⃣ Full Forecast Test:\n";
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "✅ Forecast generated successfully!\n";
        echo "- Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "- Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "- Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "- Method: " . ($forecast['forecast']['method'] ?? 'N/A') . "\n";
        echo "- Cohort count: " . ($forecast['forecast']['cohort_count'] ?? 'N/A') . "\n";
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete.\n";
?>
