<?php
/**
 * Test the column names fix
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🧪 Test Column Names Fix</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
    pre { background: #f5f5f5; padding: 10px; border-radius: 5px; }
</style>';

global $wpdb;

try {
    // Get the event with planning data
    $table_planning = $wpdb->prefix . 'coco_event_planning';
    $planning_event = $wpdb->get_row("SELECT * FROM $table_planning WHERE est_attendance > 0 LIMIT 1");
    
    if (!$planning_event) {
        echo '<p class="error">❌ No planning data found</p>';
        exit;
    }
    
    $event_id = $planning_event->event_id;
    echo '<p>Testing with event ' . $event_id . '</p>';
    
    // Check what's in the staffing table with correct column names
    $table_staffing = $wpdb->prefix . 'coco_staffing_recs';
    $saved_staffing = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $table_staffing WHERE event_id = %d ORDER BY created_at DESC LIMIT 1",
        $event_id
    ));
    
    if ($saved_staffing) {
        echo '<h2>📊 Database Values (Correct Column Names)</h2>';
        echo '<ul>';
        echo '<li><strong>Security:</strong> ' . ($saved_staffing->security ?? 'NOT SET') . '</li>';
        echo '<li><strong>Bartenders:</strong> ' . ($saved_staffing->bartenders ?? 'NOT SET') . '</li>';
        echo '<li><strong>Wait Staff:</strong> ' . ($saved_staffing->wait_staff ?? 'NOT SET') . '</li>';
        echo '<li><strong>Bottle Girls:</strong> ' . ($saved_staffing->bottle_girls ?? 'NOT SET') . '</li>';
        echo '<li><strong>Managers:</strong> ' . ($saved_staffing->managers ?? 'NOT SET') . '</li>';
        echo '</ul>';
        
        // Test the get_staffing_recommendations method
        echo '<h2>🧪 Test get_staffing_recommendations Method</h2>';
        
        // Get event features
        $table_features = $wpdb->prefix . 'coco_event_features';
        $features = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM $table_features WHERE event_id = %d",
            $event_id
        ));
        
        if ($features) {
            $rest_api = new Coco_Ops_REST_API();
            $reflection = new ReflectionClass($rest_api);
            $method = $reflection->getMethod('get_staffing_recommendations');
            $method->setAccessible(true);
            
            $result = $method->invoke($rest_api, $event_id, $saved_staffing, $planning_event, $features);
            
            echo '<h3>Method Result:</h3>';
            echo '<pre>' . print_r($result, true) . '</pre>';
            
            if (isset($result['security']) && $result['security'] > 0) {
                echo '<p class="success">✅ Method is returning correct values!</p>';
                echo '<h3>Staffing Summary:</h3>';
                echo '<p><strong>Security:</strong> ' . $result['security'] . '</p>';
                echo '<p><strong>Bartenders:</strong> ' . $result['bartenders'] . '</p>';
                echo '<p><strong>Wait Staff:</strong> ' . $result['wait_staff'] . '</p>';
                echo '<p><strong>Bottle Girls:</strong> ' . $result['bottle_girls'] . '</p>';
                echo '<p><strong>Managers:</strong> ' . $result['managers'] . '</p>';
            } else {
                echo '<p class="error">❌ Method is not returning correct values</p>';
            }
        }
        
    } else {
        echo '<p class="error">❌ No staffing data found in database</p>';
    }
    
} catch (Exception $e) {
    echo '<p class="error">❌ Error: ' . $e->getMessage() . '</p>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}

echo '<hr>';
echo '<p><strong>🚀 Next Steps:</strong></p>';
echo '<ol>';
echo '<li>If the method shows correct values, the fix is working</li>';
echo '<li>Go to Events page and check if staff rec now shows numbers</li>';
echo '<li>Check the forecast page to see if it shows saved staffing</li>';
echo '</ol>';
?>
