<?php
// Test the compute-staffing API endpoint directly
require_once('../../../wp-config.php');

$event_id = 252283;

echo "🧪 Testing Compute-Staffing API Endpoint\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

// Simulate the API request
$request_data = [
    'attendance' => 100,
    'tables' => 5,
    'use_forecast' => false
];

echo "📡 Testing with manual attendance:\n";
echo "Event ID: $event_id\n";
echo "Attendance: {$request_data['attendance']}\n";
echo "Tables: {$request_data['tables']}\n";
echo "Use Forecast: " . ($request_data['use_forecast'] ? 'Yes' : 'No') . "\n\n";

try {
    // Test the REST API method directly
    require_once('includes/class-rest-api.php');
    $rest_api = new Coco_Ops_REST_API();
    
    // Create a mock request object
    $mock_request = new stdClass();
    $mock_request->get_param = function($param) use ($event_id, $request_data) {
        if ($param === 'id') return $event_id;
        return $request_data[$param] ?? null;
    };
    
    echo "🤖 Calling compute_staffing method...\n";
    $result = $rest_api->compute_staffing($mock_request);
    
    if (is_wp_error($result)) {
        echo "❌ API Error: " . $result->get_error_message() . "\n";
    } else {
        echo "✅ API Success!\n";
        echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
} catch (Error $e) {
    echo "❌ Fatal Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

// Test with forecast
echo "\n📡 Testing with forecast:\n";
$request_data['use_forecast'] = true;
$request_data['attendance'] = null; // Will be filled by forecast

try {
    $mock_request = new stdClass();
    $mock_request->get_param = function($param) use ($event_id, $request_data) {
        if ($param === 'id') return $event_id;
        return $request_data[$param] ?? null;
    };
    
    echo "🤖 Calling compute_staffing with forecast...\n";
    $result = $rest_api->compute_staffing($mock_request);
    
    if (is_wp_error($result)) {
        echo "❌ API Error: " . $result->get_error_message() . "\n";
    } else {
        echo "✅ API Success with forecast!\n";
        echo "Response: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "\n";
}

echo "\n✅ Test complete.\n";
?>
