<?php
/**
 * Test AJAX handler directly
 */

// Include WordPress
require_once('../../../wp-config.php');

echo "<h2>🧪 Test AJAX Handler</h2>";

// Simulate the AJAX call
$_POST = [
    'action' => 'coco_ops_generate_historical_snapshots',
    'batch_size' => 2,
    'test_only' => '1',
    'nonce' => wp_create_nonce('coco_ops_historical_snapshots')
];

echo "<p><strong>Testing AJAX handler with test_only=1</strong></p>";
echo "<p>POST data: " . print_r($_POST, true) . "</p>";

// Capture output
ob_start();

// Call the function directly
coco_ops_generate_historical_snapshots();

$output = ob_get_clean();

echo "<h3>Response:</h3>";
echo "<pre>" . htmlspecialchars($output) . "</pre>";

echo "<h3>Test Complete</h3>";
?>
