<?php
if (!defined('ABSPATH')) exit;

// Comprehensive venue diagnostic
global $wpdb;

// Check all possible venue-related data
$venue_posts_all = $wpdb->get_results("SELECT ID, post_title, post_status, post_type FROM {$wpdb->posts} WHERE post_type LIKE '%venue%' OR post_title LIKE '%venue%' LIMIT 20");
$venue_meta_keys = $wpdb->get_results("SELECT DISTINCT meta_key FROM {$wpdb->postmeta} WHERE meta_key LIKE '%venue%' OR meta_key LIKE '%Venue%' LIMIT 20");
$event_meta_sample = $wpdb->get_results("SELECT post_id, meta_key, meta_value FROM {$wpdb->postmeta} WHERE meta_key LIKE '%venue%' OR meta_key LIKE '%Venue%' LIMIT 10");

// Check if The Events Calendar has different venue structure
$tribe_venues = [];
try {
    $tribe_venues = get_posts([
        'post_type'      => 'tribe_venue',
        'posts_per_page' => 5,
        'post_status'    => 'publish',
        'orderby'        => 'title',
        'order'          => 'ASC',
    ]);
} catch (Exception $e) {
    $tribe_venues = ['error' => $e->getMessage()];
}

// Check event-venue relationships
$event_venue_relationships = $wpdb->get_results("
    SELECT p.ID as event_id, p.post_title as event_title, pm.meta_key, pm.meta_value as venue_id
    FROM {$wpdb->posts} p
    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
    WHERE p.post_type = 'tribe_events'
    AND pm.meta_key LIKE '%venue%'
    LIMIT 10
");

?>

<div class="wrap coco-ops-page">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">🔍 Venue Diagnostic Tool</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Comprehensive analysis of your venue data structure
            </p>
        </div>

        <!-- The Events Calendar Functions -->
        <div class="coco-card">
            <h2 class="coco-card-title">The Events Calendar Functions</h2>
            <table style="width: 100%; font-size: 14px;">
                <tr>
                    <td style="padding: 8px; font-weight: 600;">Tribe__Events__Main class</td>
                    <td style="padding: 8px;">
                        <?php if (class_exists('Tribe__Events__Main')): ?>
                            <span class="coco-badge coco-badge-success">Available</span>
                        <?php else: ?>
                            <span class="coco-badge coco-badge-gray">Not Available</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 8px; font-weight: 600;">get_posts() for venues</td>
                    <td style="padding: 8px;">
                        <span class="coco-badge coco-badge-success">Available</span>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 8px; font-weight: 600;">get_posts() result</td>
                    <td style="padding: 8px;">
                        <?php if (is_array($tribe_venues) && !empty($tribe_venues)): ?>
                            <span class="coco-badge coco-badge-success"><?php echo count($tribe_venues); ?> venues found</span>
                        <?php elseif (isset($tribe_venues['error'])): ?>
                            <span class="coco-badge coco-badge-gray">Error: <?php echo esc_html($tribe_venues['error']); ?></span>
                        <?php else: ?>
                            <span class="coco-badge coco-badge-gray">No venues returned</span>
                        <?php endif; ?>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Database Venue Posts -->
        <div class="coco-card">
            <h2 class="coco-card-title">Database Venue Posts</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                All posts with 'venue' in type or title:
            </p>
            <?php if (!empty($venue_posts_all)): ?>
                <table class="coco-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Type</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($venue_posts_all as $post): ?>
                            <tr>
                                <td><?php echo $post->ID; ?></td>
                                <td><?php echo esc_html($post->post_title); ?></td>
                                <td><?php echo esc_html($post->post_type); ?></td>
                                <td>
                                    <span class="coco-badge <?php echo $post->post_status === 'publish' ? 'coco-badge-success' : 'coco-badge-gray'; ?>">
                                        <?php echo esc_html($post->post_status); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="color: #6B7280;">No venue-related posts found in database</p>
            <?php endif; ?>
        </div>

        <!-- Venue Meta Keys -->
        <div class="coco-card">
            <h2 class="coco-card-title">Venue Meta Keys</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                Meta keys containing 'venue':
            </p>
            <?php if (!empty($venue_meta_keys)): ?>
                <ul style="font-size: 13px;">
                    <?php foreach ($venue_meta_keys as $meta): ?>
                        <li><code><?php echo esc_html($meta->meta_key); ?></code></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p style="color: #6B7280;">No venue-related meta keys found</p>
            <?php endif; ?>
        </div>

        <!-- Event-Venue Relationships -->
        <div class="coco-card">
            <h2 class="coco-card-title">Event-Venue Relationships</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                How events are linked to venues:
            </p>
            <?php if (!empty($event_venue_relationships)): ?>
                <table class="coco-table">
                    <thead>
                        <tr>
                            <th>Event ID</th>
                            <th>Event Title</th>
                            <th>Meta Key</th>
                            <th>Venue ID</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($event_venue_relationships as $rel): ?>
                            <tr>
                                <td><?php echo $rel->event_id; ?></td>
                                <td><?php echo esc_html($rel->event_title); ?></td>
                                <td><code><?php echo esc_html($rel->meta_key); ?></code></td>
                                <td><?php echo esc_html($rel->venue_id); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="color: #6B7280;">No event-venue relationships found</p>
            <?php endif; ?>
        </div>

        <!-- Sample Event Meta -->
        <div class="coco-card">
            <h2 class="coco-card-title">Sample Event Meta</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                Venue-related meta data from events:
            </p>
            <?php if (!empty($event_meta_sample)): ?>
                <table class="coco-table">
                    <thead>
                        <tr>
                            <th>Post ID</th>
                            <th>Meta Key</th>
                            <th>Meta Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($event_meta_sample as $meta): ?>
                            <tr>
                                <td><?php echo $meta->post_id; ?></td>
                                <td><code><?php echo esc_html($meta->meta_key); ?></code></td>
                                <td><?php echo esc_html($meta->meta_value); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="color: #6B7280;">No venue-related meta data found</p>
            <?php endif; ?>
        </div>

        <!-- Quick Actions -->
        <div class="coco-card" style="background: #F0FDF4; border-color: #86EFAC;">
            <h2 class="coco-card-title">Quick Actions</h2>
            <div style="display: flex; gap: 12px; flex-wrap: wrap;">
                <button onclick="window.open('<?php echo admin_url('edit.php?post_type=tribe_venue'); ?>', '_blank')" class="coco-btn coco-btn-secondary">
                    🏢 Manage Venues
                </button>
                <button onclick="window.open('<?php echo admin_url('edit.php?post_type=tribe_events'); ?>', '_blank')" class="coco-btn coco-btn-secondary">
                    📅 Manage Events
                </button>
                <button onclick="window.location.reload()" class="coco-btn coco-btn-primary">
                    🔄 Refresh Diagnostic
                </button>
            </div>
        </div>
    </div>
</div>
