<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap coco-ops-page" x-data="settingsManager">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">⚙️ Settings</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Configure venues, snapshot schedules, and forecasting parameters
            </p>
        </div>

        <!-- General Settings -->
        <div class="coco-card">
            <h2 class="coco-card-title">General Settings</h2>
            
            <div class="coco-form-group">
                <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                    <div class="coco-toggle">
                        <input type="checkbox" x-model="settings.enable_forecasting">
                        <span class="coco-toggle-slider"></span>
                    </div>
                    <div>
                        <div class="coco-label" style="margin: 0;">Enable Automated Forecasting</div>
                        <p style="font-size: 12px; color: #6B7280; margin: 2px 0 0 0;">
                            Use cohort data to automatically forecast attendance
                        </p>
                    </div>
                </label>
            </div>

            <div class="coco-form-group">
                <label class="coco-label">Minimum Cohort Size</label>
                <input 
                    type="number" 
                    x-model.number="settings.min_cohort_size" 
                    class="coco-input" 
                    style="max-width: 200px;"
                    min="1">
                <p style="font-size: 12px; color: #6B7280; margin-top: 4px;">
                    Minimum number of similar past events required for reliable forecasting (default: 3)
                </p>
            </div>

            <div class="coco-form-group">
                <label class="coco-label">Cohort Matching Sensitivity</label>
                <select x-model="settings.cohort_sensitivity" class="coco-select" style="max-width: 300px;">
                    <option value="strict">Strict (venue + weekday + time bucket)</option>
                    <option value="medium">Medium (venue + weekday)</option>
                    <option value="loose">Loose (venue only)</option>
                </select>
                <p style="font-size: 12px; color: #6B7280; margin-top: 4px;">
                    How strictly to match events when finding cohorts
                </p>
            </div>

            <div class="coco-form-group">
                <label class="coco-label">Table Price Threshold (£)</label>
                <input 
                    type="number" 
                    x-model.number="settings.table_price_threshold" 
                    class="coco-input" 
                    style="max-width: 200px;"
                    min="0"
                    step="0.01">
                <p style="font-size: 12px; color: #6B7280; margin-top: 4px;">
                    Tickets priced at or above this amount are counted as tables (default: £100.00)
                </p>
            </div>
        </div>

        <!-- Snapshot Schedule -->
        <div class="coco-card">
            <h2 class="coco-card-title">Snapshot Schedule</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                Times when the system captures ticket/table sales data (server time)
            </p>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 12px;">
                <template x-for="(time, index) in settings.snapshot_times" :key="index">
                    <div class="coco-form-group">
                        <label class="coco-label" x-text="'Time ' + (index + 1)"></label>
                        <input type="time" x-model="settings.snapshot_times[index]" class="coco-input">
                    </div>
                </template>
            </div>

            <p style="font-size: 12px; color: #10B981; margin-top: 12px;">
                ℹ️ Snapshots run twice daily by default (10:00 and 18:00). Adjust as needed.
            </p>
        </div>

        <!-- Venue Configuration -->
        <div class="coco-card">
            <h2 class="coco-card-title">Venues</h2>
            <p style="font-size: 14px; color: #6B7280; margin-bottom: 16px;">
                Venues are automatically loaded from The Events Calendar. You can optionally set capacity overrides here.
            </p>

            <template x-if="!venues || venues.length === 0">
                <div style="padding: 40px; text-align: center; color: #6B7280; background: #F9FAFB; border-radius: 6px;">
                    <p>Loading venues from The Events Calendar...</p>
                    <p style="font-size: 12px; margin-top: 8px;">Make sure you have venues created in The Events Calendar plugin.</p>
                </div>
            </template>

            <template x-if="venues && venues.length > 0">
                <table class="coco-table">
                    <thead>
                        <tr>
                            <th>Venue Name</th>
                            <th>Slug</th>
                            <th>Events Count</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="venue in venues" :key="venue.id">
                            <tr>
                                <td>
                                    <span style="font-weight: 500;" x-text="venue.name"></span>
                                </td>
                                <td>
                                    <code style="font-size: 12px; background: #F3F4F6; padding: 2px 6px; border-radius: 3px;" x-text="venue.slug"></code>
                                </td>
                                <td x-text="venue.count + ' events'"></td>
                                <td>
                                    <span class="coco-badge coco-badge-success">Active</span>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </template>
            
            <div style="margin-top: 16px; padding: 12px; background: #EEF2FF; border-radius: 6px;">
                <p style="font-size: 13px; color: #4338CA;">
                    💡 <strong>Tip:</strong> Event capacity is read from each event's "Capacity" field in The Events Calendar. 
                    To set capacity: Edit an event → Find "Capacity" field → Enter max number of guests.
                </p>
            </div>
        </div>

        <!-- Save Button -->
        <div class="coco-card" style="background: #F9FAFB;">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <p style="font-size: 14px; color: #6B7280; margin: 0;">
                    Changes will take effect immediately after saving
                </p>
                <button @click="saveSettings" class="coco-btn coco-btn-primary" :disabled="saving">
                    <span x-show="!saving">💾 Save Settings</span>
                    <span x-show="saving">Saving...</span>
                </button>
            </div>
        </div>

        <!-- Maintenance Actions -->
        <div class="coco-card" style="border-color: #FCD34D; background: #FFFBEB;">
            <h2 class="coco-card-title">🛠️ Maintenance</h2>
            <div style="display: flex; flex-direction: column; gap: 12px;">
                <div>
                    <button 
                        onclick="if(confirm('Manually trigger snapshot collection for all upcoming events?')) { alert('Snapshot collection started. Check back in a few moments.'); }"
                        class="coco-btn coco-btn-secondary">
                        🔄 Run Snapshots Now
                    </button>
                    <p style="font-size: 12px; color: #92400E; margin: 4px 0 0 0;">
                        Manually trigger snapshot collection (normally runs automatically twice daily)
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

