<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap coco-ops-page" x-data="rulesEditor">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">⚙️ Staffing Rules</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Manage YAML rulesets that define staffing calculations
            </p>
        </div>

        <!-- Current Active Ruleset -->
        <div class="coco-card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
                <h2 class="coco-card-title" style="margin: 0;">Current Ruleset</h2>
                <template x-if="!editing">
                    <button @click="startEditing" class="coco-btn coco-btn-primary coco-btn-sm">
                        Edit & Create New Version
                    </button>
                </template>
            </div>

            <div x-show="!editing">
                <template x-if="activeRulesetId">
                    <div>
                        <div style="margin-bottom: 12px;">
                            <span class="coco-badge coco-badge-success">Active</span>
                            <span style="margin-left: 8px; font-weight: 600;" x-text="'Version ' + rulesets.find(r => r.id == activeRulesetId)?.version"></span>
                        </div>
                        <pre style="background: #1F2937; color: #F3F4F6; padding: 16px; border-radius: 6px; font-size: 13px; overflow-x: auto; max-height: 400px;"><code x-text="yamlContent"></code></pre>
                    </div>
                </template>
                <template x-if="!activeRulesetId">
                    <p style="color: #6B7280;">No active ruleset found</p>
                </template>
            </div>

            <!-- Edit Mode -->
            <div x-show="editing">
                <div class="coco-form-group">
                    <label class="coco-label">New Version Number</label>
                    <input type="text" x-model="newVersion" class="coco-input" placeholder="e.g. 1.1.0" style="max-width: 200px;">
                    <p style="font-size: 12px; color: #6B7280; margin-top: 4px;">
                        Semantic versioning: MAJOR.MINOR.PATCH
                    </p>
                </div>

                <div class="coco-form-group">
                    <label class="coco-label">YAML Content</label>
                    <textarea 
                        x-model="yamlContent" 
                        class="coco-textarea" 
                        style="min-height: 400px; font-family: monospace; font-size: 13px;"
                        spellcheck="false">
                    </textarea>
                </div>

                <div style="display: flex; gap: 12px;">
                    <button @click="saveRuleset" class="coco-btn coco-btn-primary" :disabled="saving">
                        <span x-show="!saving">Save as New Version</span>
                        <span x-show="saving">Saving...</span>
                    </button>
                    <button @click="cancelEditing" class="coco-btn coco-btn-secondary">
                        Cancel
                    </button>
                </div>
            </div>
        </div>

        <!-- Rules Documentation -->
        <div class="coco-card" style="background: #F0FDF4; border-color: #86EFAC;">
            <h2 class="coco-card-title">📘 YAML Structure Guide</h2>
            <div style="font-size: 14px; line-height: 1.7;">
                <p><strong>Required Fields:</strong></p>
                <ul style="margin: 8px 0; padding-left: 20px;">
                    <li><code>version</code> - Ruleset version number</li>
                    <li><code>rules</code> - Contains all role definitions</li>
                </ul>

                <p style="margin-top: 16px;"><strong>Role Structure (for each role):</strong></p>
                <ul style="margin: 8px 0; padding-left: 20px;">
                    <li><code>base_ratio</code> - Guests per staff member (e.g., 75 = 1 staff per 75 guests)</li>
                    <li><code>floor</code> - Minimum staff count</li>
                    <li><code>cap</code> - Maximum staff count</li>
                    <li><code>weekend_modifier</code> - Multiplier for Saturday/Sunday (optional)</li>
                    <li><code>friday_saturday_modifier</code> - Multiplier for Friday/Saturday (optional)</li>
                    <li><code>late_night_modifier</code> - Multiplier for late night events (optional)</li>
                </ul>

                <p style="margin-top: 16px;"><strong>Required Roles:</strong></p>
                <p style="margin: 4px 0;">
                    <code>security</code>, <code>bartenders</code>, <code>bottle_girls</code>, 
                    <code>wait_staff</code>, <code>managers</code>
                </p>

                <p style="margin-top: 16px;"><strong>Example Calculation:</strong></p>
                <p style="font-size: 13px; color: #047857; margin: 4px 0;">
                    For 520 guests at a Friday event:<br>
                    Base: 520 ÷ 75 = 6.93<br>
                    Weekend modifier: 6.93 × 1.15 = 7.97<br>
                    Rounded up: 8<br>
                    Result: 8 security staff
                </p>
            </div>
        </div>

        <!-- Version History -->
        <div class="coco-card">
            <h2 class="coco-card-title">Version History</h2>
            
            <template x-if="rulesets.length === 0">
                <p style="color: #6B7280;">No rulesets found</p>
            </template>

            <template x-if="rulesets.length > 0">
                <table class="coco-table">
                    <thead>
                        <tr>
                            <th>Version</th>
                            <th>Created</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="ruleset in rulesets" :key="ruleset.id">
                            <tr>
                                <td>
                                    <span style="font-weight: 600;" x-text="ruleset.version"></span>
                                </td>
                                <td x-text="new Date(ruleset.created_at).toLocaleDateString('en-GB')"></td>
                                <td>
                                    <template x-if="ruleset.active == '1'">
                                        <span class="coco-badge coco-badge-success">Active</span>
                                    </template>
                                    <template x-if="ruleset.active != '1'">
                                        <span class="coco-badge coco-badge-gray">Inactive</span>
                                    </template>
                                </td>
                                <td>
                                    <template x-if="ruleset.active != '1'">
                                        <button 
                                            @click="activateRuleset(ruleset.id)" 
                                            class="coco-btn coco-btn-sm coco-btn-primary">
                                            Activate
                                        </button>
                                    </template>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </template>
        </div>
    </div>
</div>

