<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap coco-ops-page" x-data="forecastDashboard">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">📈 Forecast Dashboard</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Track event pacing and forecast accuracy
            </p>
        </div>

        <!-- Event Selector -->
        <div class="coco-card">
            <label class="coco-label">Select Event</label>
            <select x-model="selectedEventId" @change="selectEvent(selectedEventId)" class="coco-select" style="max-width: 500px;">
                <option value="">-- Choose an event --</option>
                <template x-for="event in events" :key="event.id">
                    <option :value="event.id" x-text="event.title + ' - ' + formatDate(event.start_date)"></option>
                </template>
            </select>
        </div>

        <!-- Loading -->
        <div x-show="loading" class="coco-spinner"></div>

        <!-- Dashboard Content -->
        <template x-if="selectedEvent && !loading">
            <div>
                <!-- Getting Started Notice -->
                <template x-if="!forecast || (!forecast.current && !forecast.forecast)">
                    <div class="coco-card" style="background: #EFF6FF; border-left: 4px solid #3B82F6;">
                        <h3 style="margin: 0 0 12px 0; color: #1E40AF; font-size: 16px;">🚀 Getting Started with Forecasting</h3>
                        <p style="color: #1E40AF; margin: 0 0 12px 0; line-height: 1.6;">
                            This event doesn't have forecast data yet. Here's how to get started:
                        </p>
                        <ol style="color: #1E40AF; margin: 0; padding-left: 20px; line-height: 1.8;">
                            <li><strong>Add Manual Estimates:</strong> Go to <a href="?page=coco-ops-forecast" style="color: #1E40AF; text-decoration: underline;">Events</a> and click "Plan" to add expected attendance</li>
                            <li><strong>Snapshots (Auto):</strong> The system will automatically capture ticket sales twice daily</li>
                            <li><strong>After Events:</strong> Record actuals to build historical data for future forecasts</li>
                        </ol>
                        <p style="color: #1E40AF; margin: 12px 0 0 0; font-size: 13px;">
                            💡 <strong>Tip:</strong> The more events you complete and record actuals for, the better the automated forecasts become!
                        </p>
                    </div>
                </template>
                
                <!-- Current Status -->
                <div class="coco-card">
                    <h2 class="coco-card-title">Current Status</h2>
                    <div class="coco-stats-grid">
                        <div class="coco-stat-card">
                            <div class="coco-stat-label">Days to Event</div>
                            <div class="coco-stat-value" x-text="forecast?.current?.days_to_event?.toFixed(1) || '-'"></div>
                        </div>
                        <div class="coco-stat-card">
                            <div class="coco-stat-label">Tickets Sold</div>
                            <div class="coco-stat-value" x-text="forecast?.current?.tickets_sold || '0'"></div>
                        </div>
                        <div class="coco-stat-card">
                            <div class="coco-stat-label">Tables Sold</div>
                            <div class="coco-stat-value" x-text="forecast?.current?.tables_sold || '0'"></div>
                        </div>
                        <div class="coco-stat-card">
                            <div class="coco-stat-label">Revenue to Date</div>
                            <div class="coco-stat-value" style="font-size: 20px;">
                                £<span x-text="(forecast?.current?.revenue_to_date || 0).toFixed(0)"></span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Forecast -->
                <template x-if="forecast && forecast.forecast">
                    <div class="coco-card">
                        <h2 class="coco-card-title">Cohort Forecast</h2>
                        
                        <div class="coco-stats-grid">
                            <div class="coco-stat-card">
                                <div class="coco-stat-label">Expected Ticket Sales (p50)</div>
                                <div class="coco-stat-value" x-text="forecast.forecast.ticket_sales_p50"></div>
                                <div style="font-size: 13px; color: #6B7280; margin-top: 4px;">
                                    Range: <span x-text="forecast.forecast.ticket_sales_p25 + ' - ' + forecast.forecast.ticket_sales_p75"></span>
                                </div>
                            </div>
                            <div class="coco-stat-card">
                                <div class="coco-stat-label">Expected Attendance (p50)</div>
                                <div class="coco-stat-value" x-text="forecast.forecast.attendance_p50"></div>
                                <div style="font-size: 13px; color: #6B7280; margin-top: 4px;">
                                    Range: <span x-text="forecast.forecast.attendance_p25 + ' - ' + forecast.forecast.attendance_p75"></span>
                                </div>
                                <div style="font-size: 11px; color: #9CA3AF; margin-top: 2px;">
                                    (accounts for no-shows)
                                </div>
                            </div>
                            <div class="coco-stat-card">
                                <div class="coco-stat-label">Cohort Count</div>
                                <div class="coco-stat-value" x-text="forecast.forecast.cohort_count"></div>
                                <div style="font-size: 13px; margin-top: 4px;">
                                    <span 
                                        class="coco-badge"
                                        :class="{
                                            'coco-badge-success': forecast.forecast.confidence === 'high',
                                            'coco-badge-warning': forecast.forecast.confidence === 'medium',
                                            'coco-badge-gray': forecast.forecast.confidence === 'low'
                                        }"
                                        x-text="forecast.forecast.confidence + ' confidence'">
                                    </span>
                                </div>
                            </div>
                            <template x-if="forecast.forecast.pacing">
                                <div class="coco-stat-card">
                                    <div class="coco-stat-label">Pacing vs Cohort</div>
                                    <div class="coco-stat-value" style="font-size: 24px;">
                                        <span 
                                            :class="forecast.forecast.pacing.tickets_sold_vs_cohort > 0 ? 'positive' : 'negative'"
                                            x-text="(forecast.forecast.pacing.tickets_sold_vs_cohort > 0 ? '+' : '') + forecast.forecast.pacing.tickets_sold_vs_cohort + '%'">
                                        </span>
                                    </div>
                                    <div style="font-size: 13px; color: #6B7280; margin-top: 4px;">
                                        Cohort median: <span x-text="forecast.forecast.pacing.cohort_median_tickets"></span> tickets
                                    </div>
                                </div>
                            </template>
                        </div>

                        <template x-if="forecast.forecast.method === 'fallback'">
                            <div style="padding: 12px; background: #FEF3C7; border-radius: 6px; margin-top: 16px;">
                                <p style="font-size: 13px; color: #92400E;">
                                    ⚠️ Using fallback forecast (70% of capacity) - not enough historical cohort data yet
                                </p>
                            </div>
                        </template>
                    </div>
                </template>

                <!-- Sales Curve Chart -->
                <template x-if="snapshots.length > 0">
                    <div class="coco-card">
                        <h2 class="coco-card-title">Sales Pacing</h2>
                        <div style="position: relative; height: 300px;">
                            <canvas id="pacingChart"></canvas>
                        </div>
                    </div>
                </template>

                <!-- Recommended Staffing -->
                <template x-if="selectedEvent.staffing">
                    <div class="coco-card">
                        <h2 class="coco-card-title">Recommended Staffing</h2>
                        <div style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 16px;">
                            <div style="text-align: center; padding: 16px; background: #F9FAFB; border-radius: 8px;">
                                <div style="font-size: 32px; font-weight: 700; color: #4F46E5;" x-text="selectedEvent.staffing.security"></div>
                                <div style="font-size: 12px; color: #6B7280; margin-top: 4px;">Security</div>
                            </div>
                            <div style="text-align: center; padding: 16px; background: #F9FAFB; border-radius: 8px;">
                                <div style="font-size: 32px; font-weight: 700; color: #4F46E5;" x-text="selectedEvent.staffing.bottle_girls"></div>
                                <div style="font-size: 12px; color: #6B7280; margin-top: 4px;">Bottle Girls</div>
                            </div>
                            <div style="text-align: center; padding: 16px; background: #F9FAFB; border-radius: 8px;">
                                <div style="font-size: 32px; font-weight: 700; color: #4F46E5;" x-text="selectedEvent.staffing.wait_staff"></div>
                                <div style="font-size: 12px; color: #6B7280; margin-top: 4px;">Wait Staff</div>
                            </div>
                            <div style="text-align: center; padding: 16px; background: #F9FAFB; border-radius: 8px;">
                                <div style="font-size: 32px; font-weight: 700; color: #4F46E5;" x-text="selectedEvent.staffing.bartenders"></div>
                                <div style="font-size: 12px; color: #6B7280; margin-top: 4px;">Bartenders</div>
                            </div>
                            <div style="text-align: center; padding: 16px; background: #F9FAFB; border-radius: 8px;">
                                <div style="font-size: 32px; font-weight: 700; color: #4F46E5;" x-text="selectedEvent.staffing.managers"></div>
                                <div style="font-size: 12px; color: #6B7280; margin-top: 4px;">Managers</div>
                            </div>
                        </div>
                        <div style="margin-top: 12px; font-size: 13px; color: #6B7280;">
                            Source: <span class="coco-badge coco-badge-info" x-text="selectedEvent.staffing.source"></span>
                        </div>
                    </div>
                </template>

                <!-- Similar Events (Cohorts) -->
                <template x-if="cohorts.length > 0">
                    <div class="coco-card">
                        <h2 class="coco-card-title">Similar Past Events (Cohorts)</h2>
                        <table class="coco-table">
                            <thead>
                                <tr>
                                    <th>Event ID</th>
                                    <th>Weekday</th>
                                    <th>Time Bucket</th>
                                    <th>Final Attendance</th>
                                    <th>Final Revenue</th>
                                    <th>Similarity</th>
                                </tr>
                            </thead>
                            <tbody>
                                <template x-for="cohort in cohorts.slice(0, 10)" :key="cohort.event_id">
                                    <tr>
                                        <td x-text="cohort.event_id"></td>
                                        <td x-text="cohort.weekday"></td>
                                        <td x-text="cohort.start_bucket"></td>
                                        <td x-text="cohort.final_attendance"></td>
                                        <td>£<span x-text="cohort.final_revenue?.toFixed(2) || '-'"></span></td>
                                        <td>
                                            <span 
                                                class="coco-badge"
                                                :class="{
                                                    'coco-badge-success': cohort.similarity_score > 0.7,
                                                    'coco-badge-info': cohort.similarity_score <= 0.7
                                                }"
                                                x-text="(cohort.similarity_score * 100).toFixed(0) + '%'">
                                            </span>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>
                </template>
            </div>
        </template>

        <!-- Empty State -->
        <template x-if="!selectedEventId && !loading">
            <div class="coco-card" style="padding: 60px; text-align: center;">
                <p style="font-size: 16px; color: #6B7280;">Select an event above to view its forecast dashboard</p>
            </div>
        </template>
    </div>
</div>

