<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap coco-ops-page" x-data="eventsList">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">📊 Events & Staffing</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Forecast attendance and recommend staffing for upcoming events
            </p>
        </div>

        <!-- Filters -->
        <div class="coco-card">
            <div class="coco-filters">
                <div class="coco-filter-item">
                    <label class="coco-label">Venue</label>
                    <select x-model="filters.venue" @change="applyFilters" class="coco-select">
                        <option value="">All Venues</option>
                        <template x-for="venue in venues" :key="venue.id">
                            <option :value="venue.id" x-text="venue.name + ' (' + venue.count + ')'"></option>
                        </template>
                    </select>
                </div>
                
                <div class="coco-filter-item">
                    <label class="coco-label">Start Date</label>
                    <input type="date" x-model="filters.start_date" @change="applyFilters" class="coco-input">
                </div>
                
                <div class="coco-filter-item">
                    <label class="coco-label">End Date</label>
                    <input type="date" x-model="filters.end_date" @change="applyFilters" class="coco-input">
                </div>
                
                <div class="coco-filter-item">
                    <label class="coco-label">Status</label>
                    <select x-model="filters.has_actuals" @change="applyFilters" class="coco-select">
                        <option :value="null">All Events</option>
                        <option :value="false">No Actuals</option>
                        <option :value="true">Has Actuals</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Events Table -->
        <div class="coco-card" style="padding: 0;">
            <div x-show="loading" class="coco-spinner"></div>
            
            <div x-show="!loading">
                <template x-if="events.length === 0">
                    <div style="padding: 60px; text-align: center; color: #6B7280;">
                        <p style="font-size: 16px;">No events found</p>
                        <p style="font-size: 14px; margin-top: 8px;">Make sure:</p>
                        <ul style="text-align: left; max-width: 400px; margin: 16px auto;">
                            <li>The Events Calendar plugin is active</li>
                            <li>You have published events with future start dates</li>
                            <li>Events are assigned to venues</li>
                        </ul>
                        <button @click="loadEvents" class="coco-btn coco-btn-secondary" style="margin-top: 16px;">
                            🔄 Refresh
                        </button>
                    </div>
                </template>
                
                <template x-if="events.length > 0">
                    <table class="coco-table">
                        <thead>
                            <tr>
                                <th>Date/Time</th>
                                <th>Event</th>
                                <th>Venue</th>
                                <th>Capacity</th>
                                <th>Current Sales</th>
                                <th>Expected</th>
                                <th>Staff Rec</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-for="event in events" :key="event.id">
                                <tr>
                                    <td>
                                        <div style="font-weight: 500;" x-text="formatDate(event.start_date)"></div>
                                        <div style="font-size: 12px; color: #6B7280;" x-text="event.weekday + ' ' + event.start_bucket"></div>
                                    </td>
                                    <td>
                                        <div style="font-weight: 500;" x-text="event.title"></div>
                                        <template x-if="event.tags && event.tags.length > 0">
                                            <div style="margin-top: 4px;">
                                                <template x-for="tag in event.tags.slice(0, 2)">
                                                    <span class="coco-badge coco-badge-gray" style="margin-right: 4px;" x-text="tag"></span>
                                                </template>
                                            </div>
                                        </template>
                                    </td>
                                    <td x-text="event.venue_name"></td>
                                    <td x-text="event.capacity"></td>
                                    <td>
                                        <div>
                                            <div x-text="(event.current_live ? event.current_live.tickets_sold : (event.current_snapshot ? event.current_snapshot.tickets_sold : 0)) + ' tickets'"></div>
                                            <div style="font-size: 12px; color: #6B7280;" x-text="(event.current_live ? event.current_live.tables_sold : (event.current_snapshot ? event.current_snapshot.tables_sold : 0)) + ' tables'"></div>
                                            <!-- Target to match cohort at this D (median) -->
                                            <template x-if="event.pacing_pct !== null && event.pacing_pct > 0">
                                                <div style="font-size: 11px; color:#374151; margin-top:2px;">
                                                    <span style="color:#6B7280;">Target:</span>
                                                    <span x-text="Math.round((event.current_live ? event.current_live.tickets_sold : (event.current_snapshot ? event.current_snapshot.tickets_sold : 0)) / (event.pacing_pct / 100)) + ' tickets'" />
                                                </div>
                                            </template>
                                            <div x-show="event.pacing_pct !== null" style="font-size: 11px; color: #6B7280; display:flex; align-items:center; gap:6px; margin-top:2px;">
                                                <template x-if="event.pacing_pct > 105">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#10B981;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
                                                    </svg>
                                                </template>
                                                <template x-if="event.pacing_pct < 95">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#EF4444;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3" />
                                                    </svg>
                                                </template>
                                                <template x-if="event.pacing_pct >= 95 && event.pacing_pct <= 105">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#6B7280;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 12h16" />
                                                    </svg>
                                                </template>
                                                <span x-text="event.pacing_pct + '%'" />
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <template x-if="event.planning && event.planning.est_attendance">
                                            <div>
                                                <span class="coco-badge coco-badge-info" x-text="event.planning.est_attendance + ' guests'"></span>
                                            </div>
                                        </template>
                                        <template x-if="!event.planning || !event.planning.est_attendance">
                                            <span class="coco-badge coco-badge-gray">Not set</span>
                                        </template>
                                    </td>
                                    <td>
                                        <template x-if="event.staffing">
                                            <div style="font-family: monospace; font-size: 13px;" x-text="getStaffingSummary(event.staffing)"></div>
                                            <div style="font-size: 11px; color: #6B7280;">Sec/Bot/Wait/Bar/Mgr</div>
                                        </template>
                                        <template x-if="!event.staffing">
                                            <span style="color: #9CA3AF;">-</span>
                                        </template>
                                    </td>
                                    <td>
                                        <div style="display: flex; gap: 6px;">
                                            <button @click="openPlanModal(event)" class="coco-btn coco-btn-sm coco-btn-primary">
                                                Plan
                                            </button>
                                            <button @click="openActualsModal(event)" class="coco-btn coco-btn-sm coco-btn-secondary">
                                                Actuals
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </template>
            </div>
        </div>
    </div>

    <!-- Planning Modal -->
    <template x-if="showPlanModal && selectedEvent">
        <div class="coco-modal-backdrop" @click.self="showPlanModal = false">
            <div class="coco-modal" x-data="planningModal(selectedEvent)" style="max-width: 700px;">
                <div class="coco-modal-header">
                    <h2 class="coco-modal-title" x-text="'Plan: ' + selectedEvent.title"></h2>
                    <p style="font-size: 13px; color: #6B7280; margin: 4px 0 0 0;" x-text="formatDate(selectedEvent.start_date)"></p>
                </div>
                
                <div class="coco-modal-body">
                    <!-- Mode Toggle -->
                    <div style="margin-bottom: 20px; display: flex; gap: 8px;">
                        <button 
                            @click="switchMode('manual')" 
                            :class="mode === 'manual' ? 'coco-btn-primary' : 'coco-btn-secondary'"
                            class="coco-btn"
                            style="flex: 1;">
                            Manual Estimate
                        </button>
                        <button 
                            @click="switchMode('auto')" 
                            :class="mode === 'auto' ? 'coco-btn-primary' : 'coco-btn-secondary'"
                            class="coco-btn"
                            style="flex: 1;">
                            Auto Forecast
                        </button>
                    </div>

                    <!-- Manual Mode -->
                    <div x-show="mode === 'manual'">
                        <div class="coco-form-group">
                            <label class="coco-label">Expected Ticket Sales *</label>
                            <input type="number" x-model="est_attendance" class="coco-input" placeholder="e.g. 520 tickets">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Expected Tables</label>
                            <input type="number" x-model="est_tables" class="coco-input" placeholder="Optional">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Notes</label>
                            <textarea x-model="notes" class="coco-textarea" placeholder="Any additional notes..."></textarea>
                        </div>
                        
                        <button @click="computeStaffing" class="coco-btn coco-btn-primary" style="width: 100%;" :disabled="loading">
                            <span x-show="!loading">Compute Staffing</span>
                            <span x-show="loading">Computing...</span>
                        </button>
                    </div>

                    <!-- Auto Mode -->
                    <div x-show="mode === 'auto'">
                        <div x-show="loading" class="coco-spinner" style="margin: 20px auto;"></div>
                        
                        <template x-if="forecast && !loading">
                            <div>
                                <div class="coco-stats-grid" style="margin-bottom: 16px;">
                                    <div class="coco-stat-card">
                                        <div class="coco-stat-label">Current Sales</div>
                                        <div style="display:flex; align-items:center; gap:8px;">
                                            <div class="coco-stat-value" style="font-size: 20px;" x-text="(forecast.current ? forecast.current.tickets_sold : 0) + ' tix'"></div>
                                            <!-- Pacing signal: compare current vs cohort median at same D -->
                                            <template x-if="forecast.forecast && forecast.forecast.pacing && forecast.forecast.pacing.tickets_sold_vs_cohort">
                                                <div :title="'Pacing vs cohort: ' + forecast.forecast.pacing.tickets_sold_vs_cohort + '%'" style="display:flex; align-items:center;">
                                                    <svg x-show="forecast.forecast.pacing.tickets_sold_vs_cohort > 105" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#10B981;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
                                                    </svg>
                                                    <svg x-show="forecast.forecast.pacing.tickets_sold_vs_cohort < 95" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#EF4444;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3" />
                                                    </svg>
                                                    <svg x-show="forecast.forecast.pacing.tickets_sold_vs_cohort >= 95 && forecast.forecast.pacing.tickets_sold_vs_cohort <= 105" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="color:#6B7280;">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 12h16" />
                                                    </svg>
                                                </div>
                                            </template>
                                        </div>
                                        <div x-show="forecast.forecast && forecast.forecast.pacing && forecast.forecast.pacing.tickets_sold_vs_cohort" style="font-size:11px; color:#6B7280; margin-top:4px;">
                                            <span x-text="forecast.forecast.pacing.tickets_sold_vs_cohort + '%' "></span> vs cohort now
                                        </div>
                                    </div>
                                    <div class="coco-stat-card">
                                        <div class="coco-stat-label">Days to Event</div>
                                        <div class="coco-stat-value" style="font-size: 20px;" x-text="(forecast.current ? forecast.current.days_to_event.toFixed(1) : 'N/A')"></div>
                                    </div>
                                    <div class="coco-stat-card">
                                        <div class="coco-stat-label">Forecast (p50)</div>
                                        <div class="coco-stat-value" style="font-size: 20px;" x-text="(forecast.forecast ? forecast.forecast.attendance_p50 : 'N/A')"></div>
                                        <div style="font-size: 11px; color: #6B7280;" x-show="forecast.forecast">
                                            <span x-text="forecast.forecast.attendance_p25 + '-' + forecast.forecast.attendance_p75"></span> range
                                        </div>
                                    </div>
                                </div>
                                
                                <div style="padding: 12px; background: #F3F4F6; border-radius: 6px; margin-bottom: 16px;">
                                    <p style="font-size: 13px; color: #374151;">
                                        Based on <strong x-text="forecast.forecast.cohort_count"></strong> similar past events
                                        (<span x-text="forecast.forecast.confidence"></span> confidence)
                                    </p>
                                    <template x-if="forecast.forecast.pacing">
                                        <p style="font-size: 13px; color: #374151; margin-top: 4px;">
                                            Pacing: <strong x-text="forecast.forecast.pacing.tickets_sold_vs_cohort + '%'"></strong> vs cohort median
                                        </p>
                                    </template>
                                </div>
                                
                                <button @click="computeStaffing" class="coco-btn coco-btn-primary" style="width: 100%;">
                                    Use Auto Forecast & Compute Staffing
                                </button>
                            </div>
                        </template>
                        
                        <template x-if="!forecast && !loading">
                            <div style="padding: 20px; text-align: center; color: #6B7280;">
                                <p>No forecast data available yet.</p>
                                <p style="font-size: 13px; margin-top: 8px;">This event needs historical data to generate forecasts.</p>
                                <button @click="switchMode('manual')" class="coco-btn coco-btn-secondary" style="margin-top: 12px;">
                                    Switch to Manual Mode
                                </button>
                            </div>
                        </template>
                    </div>

                    <!-- Staffing Results -->
                    <template x-if="staffing">
                        <div style="margin-top: 20px; padding: 16px; background: #F0FDF4; border: 2px solid #10B981; border-radius: 8px;">
                            <h3 style="font-size: 16px; font-weight: 600; margin: 0 0 12px 0;">Recommended Staffing</h3>
                            
                            <div style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 12px; margin-bottom: 12px;">
                                <div style="text-align: center;">
                                    <div style="font-size: 24px; font-weight: 700; color: #059669;" x-text="staffing.staffing.security"></div>
                                    <div style="font-size: 11px; color: #047857;">Security</div>
                                </div>
                                <div style="text-align: center;">
                                    <div style="font-size: 24px; font-weight: 700; color: #059669;" x-text="staffing.staffing.bottle_girls"></div>
                                    <div style="font-size: 11px; color: #047857;">Bottle Girls</div>
                                </div>
                                <div style="text-align: center;">
                                    <div style="font-size: 24px; font-weight: 700; color: #059669;" x-text="staffing.staffing.wait_staff"></div>
                                    <div style="font-size: 11px; color: #047857;">Wait Staff</div>
                                </div>
                                <div style="text-align: center;">
                                    <div style="font-size: 24px; font-weight: 700; color: #059669;" x-text="staffing.staffing.bartenders"></div>
                                    <div style="font-size: 11px; color: #047857;">Bartenders</div>
                                </div>
                                <div style="text-align: center;">
                                    <div style="font-size: 24px; font-weight: 700; color: #059669;" x-text="staffing.staffing.managers"></div>
                                    <div style="font-size: 11px; color: #047857;">Managers</div>
                                </div>
                            </div>
                            
                            <details style="font-size: 13px;">
                                <summary style="cursor: pointer; color: #047857; font-weight: 500;">View calculation details</summary>
                                <div class="coco-markdown" style="margin-top: 12px; padding-top: 12px; border-top: 1px solid #86EFAC;" x-html="staffing.rationale_md.replace(/\n/g, '<br>')"></div>
                            </details>
                        </div>
                    </template>
                </div>
                
                <div class="coco-modal-footer">
                    <button @click="showPlanModal = false" class="coco-btn coco-btn-secondary">
                        Cancel
                    </button>
                    <button @click="savePlan" class="coco-btn coco-btn-primary" :disabled="!staffing || saving">
                        <span x-show="!saving">Save Plan</span>
                        <span x-show="saving">Saving...</span>
                    </button>
                </div>
            </div>
        </div>
    </template>

    <!-- Actuals Modal -->
    <template x-if="showActualsModal && selectedEvent">
        <div class="coco-modal-backdrop" @click.self="showActualsModal = false">
            <div class="coco-modal" x-data="actualsModal(selectedEvent)">
                <div class="coco-modal-header">
                    <h2 class="coco-modal-title" x-text="'Actuals: ' + selectedEvent.title"></h2>
                    <p style="font-size: 13px; color: #6B7280; margin: 4px 0 0 0;" x-text="formatDate(selectedEvent.start_date)"></p>
                </div>
                
                <div class="coco-modal-body">
                    <div class="coco-form-group">
                        <label class="coco-label">Final Attendance *</label>
                        <input type="number" x-model="final_attendance" class="coco-input" required>
                    </div>
                    
                    <div class="coco-form-group">
                        <label class="coco-label">Final Revenue</label>
                        <input type="number" step="0.01" x-model="final_revenue" class="coco-input" placeholder="£">
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px;">
                        <div class="coco-form-group">
                            <label class="coco-label">Bartenders Used</label>
                            <input type="number" x-model="actual_bartenders" class="coco-input">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Bottle Girls Used</label>
                            <input type="number" x-model="actual_bottle_girls" class="coco-input">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Wait Staff Used</label>
                            <input type="number" x-model="actual_wait" class="coco-input">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Security Used</label>
                            <input type="number" x-model="actual_security" class="coco-input">
                        </div>
                        
                        <div class="coco-form-group">
                            <label class="coco-label">Managers Used</label>
                            <input type="number" x-model="actual_managers" class="coco-input">
                        </div>
                    </div>
                    
                    <!-- Performance Metrics -->
                    <div class="coco-card" style="margin: 20px 0; padding: 16px; background: #f8fafc;">
                        <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #374151;">Performance Metrics</h3>
                        
                        <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px; margin-bottom: 16px;">
                            <div class="coco-form-group">
                                <label class="coco-label">Revenue per Staff</label>
                                <div class="coco-input" style="background: #f3f4f6; color: #6b7280;" x-text="calculateRevenuePerStaff()"></div>
                            </div>
                            
                            <div class="coco-form-group">
                                <label class="coco-label">Staff Efficiency</label>
                                <div class="coco-input" style="background: #f3f4f6; color: #6b7280;" x-text="calculateStaffEfficiency()"></div>
                            </div>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px;">
                            <div class="coco-form-group">
                                <label class="coco-label">Forecast Accuracy</label>
                                <div class="coco-input" style="background: #f3f4f6; color: #6b7280;" x-text="calculateForecastAccuracy()"></div>
                            </div>
                            
                            <div class="coco-form-group">
                                <label class="coco-label">Capacity Utilization</label>
                                <div class="coco-input" style="background: #f3f4f6; color: #6b7280;" x-text="calculateCapacityUtilization()"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="coco-form-group">
                        <label class="coco-label">Notes</label>
                        <textarea x-model="notes" class="coco-textarea" placeholder="What worked well? What didn't?"></textarea>
                    </div>
                    
                    <div class="coco-form-group">
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input type="checkbox" x-model="locked">
                            <span class="coco-label" style="margin: 0;">Lock this entry (prevent edits)</span>
                        </label>
                    </div>
                </div>
                
                <div class="coco-modal-footer">
                    <button @click="showActualsModal = false" class="coco-btn coco-btn-secondary">
                        Cancel
                    </button>
                    <button @click="saveActuals" class="coco-btn coco-btn-primary" :disabled="saving">
                        <span x-show="!saving">Save Actuals</span>
                        <span x-show="saving">Saving...</span>
                    </button>
                </div>
            </div>
        </div>
    </template>
</div>

