<div class="wrap">
    <h1 class="wp-heading-inline">🔍 Debug Reports Data</h1>
    <hr class="wp-header-end">
    
    <div class="coco-card">
        <h2>Latest Report Data</h2>
        
        <?php
        global $wpdb;
        
        // Get the latest report
        $latest_report = $wpdb->get_row("
            SELECT * FROM {$wpdb->prefix}coco_event_reports 
            ORDER BY generated_at DESC 
            LIMIT 1
        ");
        
        if (!$latest_report) {
            echo '<p>No reports found.</p>';
        } else {
            echo '<h3>Report Details:</h3>';
            echo '<ul>';
            echo '<li><strong>Event ID:</strong> ' . esc_html($latest_report->event_id) . '</li>';
            echo '<li><strong>Event Title:</strong> ' . esc_html($latest_report->event_title) . '</li>';
            echo '<li><strong>Venue ID:</strong> ' . esc_html($latest_report->venue_id) . '</li>';
            echo '<li><strong>Event Date:</strong> ' . esc_html($latest_report->event_date) . '</li>';
            echo '</ul>';
            
            // Check if venue exists
            if ($latest_report->venue_id) {
                $venue_post = get_post($latest_report->venue_id);
                if ($venue_post) {
                    echo '<p><strong>Venue Name:</strong> ' . esc_html($venue_post->post_title) . '</p>';
                } else {
                    echo '<p><strong>Venue:</strong> Not found for ID: ' . esc_html($latest_report->venue_id) . '</p>';
                }
            }
            
            // Parse report data
            $report_data = json_decode($latest_report->report_data, true);
            
            echo '<h3>Actuals Data:</h3>';
            echo '<pre>' . esc_html(json_encode($report_data['actuals'] ?? [], JSON_PRETTY_PRINT)) . '</pre>';
            
            echo '<h3>Forecast Data:</h3>';
            $forecast = $report_data['forecast'] ?? [];
            echo '<ul>';
            echo '<li><strong>Source:</strong> ' . esc_html($forecast['source'] ?? 'unknown') . '</li>';
            echo '<li><strong>Planned Attendance:</strong> ' . esc_html($forecast['planned_attendance'] ?? 'N/A') . '</li>';
            echo '<li><strong>Planned Revenue:</strong> £' . esc_html($forecast['planned_revenue'] ?? 'N/A') . '</li>';
            if (isset($forecast['confidence'])) {
                echo '<li><strong>Confidence:</strong> ' . esc_html($forecast['confidence']) . '</li>';
            }
            if (isset($forecast['cohort_count'])) {
                echo '<li><strong>Cohort Count:</strong> ' . esc_html($forecast['cohort_count']) . '</li>';
            }
            echo '</ul>';
            echo '<pre>' . esc_html(json_encode($forecast, JSON_PRETTY_PRINT)) . '</pre>';
            
            echo '<h3>Metrics Data:</h3>';
            echo '<pre>' . esc_html(json_encode($report_data['metrics'] ?? [], JSON_PRETTY_PRINT)) . '</pre>';
            
            // Check if there's planning data for this event
            $planning = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}coco_event_planning WHERE event_id = %d",
                $latest_report->event_id
            ));
            
            echo '<h3>Planning Data:</h3>';
            if ($planning) {
                echo '<ul>';
                echo '<li><strong>Est Attendance:</strong> ' . esc_html($planning->est_attendance) . '</li>';
                echo '<li><strong>Est Revenue:</strong> £' . esc_html($planning->est_revenue) . '</li>';
                echo '<li><strong>Est Tables:</strong> ' . esc_html($planning->est_tables) . '</li>';
                echo '</ul>';
            } else {
                echo '<p><strong>No planning data found for this event.</strong><br>';
                echo 'This is why forecast accuracy is 0%.</p>';
            }
            
            // Check if there are any events with planning data
            $planning_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_planning");
            echo '<h3>Planning Data Summary:</h3>';
            echo '<p>Total planning entries: ' . esc_html($planning_count) . '</p>';
            
            if ($planning_count > 0) {
                $sample_planning = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}coco_event_planning ORDER BY created_at DESC LIMIT 1");
                echo '<p><strong>Sample planning entry:</strong></p>';
                echo '<ul>';
                echo '<li><strong>Event ID:</strong> ' . esc_html($sample_planning->event_id) . '</li>';
                echo '<li><strong>Est Attendance:</strong> ' . esc_html($sample_planning->est_attendance) . '</li>';
                echo '</ul>';
            }
        }
        ?>
        
        <h3>Quick Actions:</h3>
        <p>
            <a href="<?php echo admin_url('admin.php?page=coco-ops-reports'); ?>" class="button button-primary">
                View Reports Dashboard
            </a>
            <a href="<?php echo admin_url('admin.php?page=coco-ops-forecast'); ?>" class="button">
                View Events
            </a>
        </p>
    </div>
</div>
