<?php
if (!defined('ABSPATH')) exit;
?>

<div class="wrap coco-ops-page">
    <div class="coco-ops-container">
        <!-- Header -->
        <div class="coco-ops-header">
            <h1 class="coco-ops-title">ℹ️ About Ops Forecast</h1>
            <p style="color: #6B7280; margin-top: 8px;">
                Version <?php echo COCO_OPS_VERSION; ?>
            </p>
        </div>

        <!-- Overview -->
        <div class="coco-card">
            <h2 class="coco-card-title">🎯 What This Plugin Does</h2>
            <div style="font-size: 14px; line-height: 1.7; color: #374151;">
                <p>
                    <strong>Coco Ops Forecast & Staffing Recommender</strong> is an operations intelligence plugin 
                    built specifically for Cococure's multi-venue group. It helps managers plan, forecast, and staff 
                    upcoming events in a structured, data-driven way.
                </p>
                <p style="margin-top: 12px;">
                    The plugin ensures the right number of bartenders, bottle girls, wait staff, security, and managers 
                    are scheduled for every event — no overstaffing, no understaffing — using data from past events, 
                    ticket sales, and cohort forecasting.
                </p>
            </div>
        </div>

        <!-- How It Works -->
        <div class="coco-card">
            <h2 class="coco-card-title">⚙️ How It Works</h2>
            <div style="display: grid; gap: 16px;">
                <!-- Stage 1 -->
                <div style="padding: 16px; background: #EEF2FF; border-left: 4px solid #4F46E5; border-radius: 6px;">
                    <h3 style="font-size: 15px; font-weight: 600; margin: 0 0 8px 0; color: #4338CA;">
                        Stage 1: Manual Planning
                    </h3>
                    <p style="font-size: 13px; color: #4338CA; margin: 0; line-height: 1.6;">
                        Manager enters expected attendance for an event. The system runs a rules engine (YAML-based) 
                        that translates estimates into staffing recommendations with detailed rationale.
                    </p>
                </div>

                <!-- Stage 2 -->
                <div style="padding: 16px; background: #D1FAE5; border-left: 4px solid #10B981; border-radius: 6px;">
                    <h3 style="font-size: 15px; font-weight: 600; margin: 0 0 8px 0; color: #047857;">
                        Stage 2: Actuals Entry
                    </h3>
                    <p style="font-size: 13px; color: #047857; margin: 0; line-height: 1.6;">
                        After each event, managers record final attendance, actual staff used, and notes. 
                        These "actuals" feed the historical database for future learning.
                    </p>
                </div>

                <!-- Stage 3 -->
                <div style="padding: 16px; background: #FEF3C7; border-left: 4px solid #F59E0B; border-radius: 6px;">
                    <h3 style="font-size: 15px; font-weight: 600; margin: 0 0 8px 0; color: #92400E;">
                        Stage 3: Automated Snapshots
                    </h3>
                    <p style="font-size: 13px; color: #92400E; margin: 0; line-height: 1.6;">
                        The system automatically records twice-daily snapshots of tickets, tables, and revenue 
                        as events approach. This creates a rich D-X (days-to-event) dataset for forecasting.
                    </p>
                </div>

                <!-- Stage 4 -->
                <div style="padding: 16px; background: #DBEAFE; border-left: 4px solid #3B82F6; border-radius: 6px;">
                    <h3 style="font-size: 15px; font-weight: 600; margin: 0 0 8px 0; color: #1E40AF;">
                        Stage 4: Cohort Forecasting
                    </h3>
                    <p style="font-size: 13px; color: #1E40AF; margin: 0; line-height: 1.6;">
                        Once enough data is collected, the system begins forecasting outcomes based on similar past events 
                        ("cohort forecasting"). Shows pacing vs cohort median (e.g., "This Friday is +18% vs median of last 10 Fridays at D-3").
                    </p>
                </div>
            </div>
        </div>

        <!-- Key Features -->
        <div class="coco-card">
            <h2 class="coco-card-title">✨ Key Features</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 16px;">
                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">📊</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">Dual Forecasting Modes</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        Manual estimates for immediate use, automated forecasts that improve over time
                    </p>
                </div>

                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">🎯</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">Staffing Recommendations</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        5 roles (security, bartenders, bottle girls, wait staff, managers) with transparent rationale
                    </p>
                </div>

                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">📈</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">Pacing Analysis</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        See how current sales compare to similar past events at the same point in time
                    </p>
                </div>

                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">🔄</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">Continuous Learning</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        Every actuals entry makes future forecasts more accurate
                    </p>
                </div>

                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">📸</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">Automated Snapshots</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        Twice-daily capture of ticket/table sales without manual intervention
                    </p>
                </div>

                <div style="padding: 12px; background: #F9FAFB; border-radius: 6px;">
                    <div style="font-size: 20px; margin-bottom: 6px;">⚙️</div>
                    <h4 style="font-size: 14px; font-weight: 600; margin: 0 0 4px 0;">YAML Rules Engine</h4>
                    <p style="font-size: 13px; color: #6B7280; margin: 0;">
                        Human-readable formulas with versioning for tracking changes over time
                    </p>
                </div>
            </div>
        </div>

        <!-- Technical Details -->
        <div class="coco-card">
            <h2 class="coco-card-title">🔧 Technical Details</h2>
            <table style="width: 100%; font-size: 13px;">
                <tr style="border-bottom: 1px solid #E5E7EB;">
                    <td style="padding: 8px; font-weight: 600; color: #374151;">Version</td>
                    <td style="padding: 8px; color: #6B7280;"><?php echo COCO_OPS_VERSION; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #E5E7EB;">
                    <td style="padding: 8px; font-weight: 600; color: #374151;">Database Tables</td>
                    <td style="padding: 8px; color: #6B7280;">6 custom tables (features, snapshots, planning, staffing_recs, actuals, rulesets)</td>
                </tr>
                <tr style="border-bottom: 1px solid #E5E7EB;">
                    <td style="padding: 8px; font-weight: 600; color: #374151;">Cron Schedule</td>
                    <td style="padding: 8px; color: #6B7280;">Twice daily (10:00 AM, 6:00 PM server time)</td>
                </tr>
                <tr style="border-bottom: 1px solid #E5E7EB;">
                    <td style="padding: 8px; font-weight: 600; color: #374151;">Frontend Framework</td>
                    <td style="padding: 8px; color: #6B7280;">Alpine.js 3.13 + Tailwind CSS + Chart.js</td>
                </tr>
                <tr style="border-bottom: 1px solid #E5E7EB;">
                    <td style="padding: 8px; font-weight: 600; color: #374151;">API Namespace</td>
                    <td style="padding: 8px; color: #6B7280;">/wp-json/coco-ops/v1/</td>
                </tr>
                <tr>
                    <td style="padding: 8px; font-weight: 600; color: #374151;">Integrations</td>
                    <td style="padding: 8px; color: #6B7280;">The Events Calendar, Event Tickets Plus, WooCommerce</td>
                </tr>
            </table>
        </div>

        <!-- Workflow -->
        <div class="coco-card" style="background: #F0FDF4; border-color: #86EFAC;">
            <h2 class="coco-card-title">📋 Recommended Workflow</h2>
            <ol style="font-size: 14px; line-height: 1.8; color: #047857; padding-left: 20px;">
                <li><strong>Week 1-2:</strong> Enter past event actuals to build initial dataset</li>
                <li><strong>Week 3-4:</strong> Use manual mode for upcoming events, let snapshots run automatically</li>
                <li><strong>Week 5-6:</strong> Start reviewing forecast dashboard to see cohort predictions</li>
                <li><strong>Week 7+:</strong> Switch to auto forecast mode for events with strong cohort data</li>
                <li><strong>Monthly:</strong> Review staffing accuracy and adjust YAML rules if needed</li>
            </ol>
        </div>

        <!-- Support -->
        <div class="coco-card">
            <h2 class="coco-card-title">💬 Support & Documentation</h2>
            <p style="font-size: 14px; color: #374151; margin-bottom: 12px;">
                For questions, issues, or feature requests, contact the development team.
            </p>
            <div style="display: flex; gap: 12px;">
                <button class="coco-btn coco-btn-secondary" onclick="alert('Documentation coming soon!')">
                    📚 View Documentation
                </button>
                <button class="coco-btn coco-btn-secondary" onclick="alert('Contact: tech@cococure.co.uk')">
                    ✉️ Contact Support
                </button>
            </div>
        </div>
    </div>
</div>

