<?php
// Simple test to verify rule enforcement
require_once('../../../wp-config.php');

$event_id = 250474;

echo "🧪 Simple Forecast Test for Event $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

// Test the calculate_paid_tickets_and_tables method directly
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    
    // Use reflection to access the private method
    $reflection = new ReflectionClass($forecasting_engine);
    $method = $reflection->getMethod('calculate_paid_tickets_and_tables');
    $method->setAccessible(true);
    
    $paid_tickets_and_tables = $method->invoke($forecasting_engine, $event_id);
    
    echo "📊 Direct Method Test:\n";
    echo "Paid tickets + table entries: $paid_tickets_and_tables\n\n";
    
    // Test the full forecast
    echo "🤖 Full Forecast Test:\n";
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        $forecast_tickets = $forecast['forecast']['ticket_sales_p50'] ?? 0;
        $forecast_attendance = $forecast['forecast']['attendance_p50'] ?? 0;
        
        echo "Generated forecast:\n";
        echo "- Ticket sales p50: $forecast_tickets\n";
        echo "- Attendance p50: $forecast_attendance\n";
        echo "Expected minimum attendance: $paid_tickets_and_tables\n";
        
        if ($forecast_attendance >= $paid_tickets_and_tables) {
            echo "✅ SUCCESS: Attendance forecast respects the rule\n";
        } else {
            echo "❌ FAILED: Attendance forecast does not respect the rule\n";
            echo "Difference: " . ($paid_tickets_and_tables - $forecast_attendance) . "\n";
        }
        
        // Show all forecast values
        echo "\nFull forecast data:\n";
        foreach ($forecast['forecast'] as $key => $value) {
            echo "- $key: $value\n";
        }
    } else {
        echo "❌ Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n✅ Test complete.\n";
?>
