<?php
// Simple debug without WordPress
echo "=== SIMPLE REPORTS DEBUG ===\n";

// Check if we can connect to the database
$host = 'localhost';
$dbname = 'cococure_com';
$username = 'cococure_com';
$password = 'your_password_here'; // You'll need to replace this

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Database connection: SUCCESS\n";
    
    // Check reports table
    $stmt = $pdo->query("SHOW TABLES LIKE 'wp_coco_event_reports'");
    $reports_table_exists = $stmt->rowCount() > 0;
    echo "Reports table exists: " . ($reports_table_exists ? 'YES' : 'NO') . "\n";
    
    if ($reports_table_exists) {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM wp_coco_event_reports");
        $count = $stmt->fetch()['count'];
        echo "Reports count: $count\n";
    }
    
    // Check actuals table
    $stmt = $pdo->query("SHOW TABLES LIKE 'wp_coco_event_actuals'");
    $actuals_table_exists = $stmt->rowCount() > 0;
    echo "Actuals table exists: " . ($actuals_table_exists ? 'YES' : 'NO') . "\n";
    
    if ($actuals_table_exists) {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM wp_coco_event_actuals");
        $count = $stmt->fetch()['count'];
        echo "Actuals count: $count\n";
        
        if ($count > 0) {
            $stmt = $pdo->query("SELECT * FROM wp_coco_event_actuals ORDER BY entered_at DESC LIMIT 1");
            $sample = $stmt->fetch();
            echo "Sample actuals entry:\n";
            print_r($sample);
        }
    }
    
} catch (PDOException $e) {
    echo "Database connection failed: " . $e->getMessage() . "\n";
    echo "Please check your database credentials.\n";
}

echo "\n=== END DEBUG ===\n";
?>
