<?php
/**
 * Setup Forecasting System
 * This will help you understand what's needed for forecasting to work
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🚀 Setup Forecasting System</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
    .warning { color: #F59E0B; }
    pre { background: #f5f5f5; padding: 10px; border-radius: 5px; }
    .step { background: #F0FDF4; padding: 15px; border-radius: 8px; margin: 10px 0; border-left: 4px solid #10B981; }
    .step h3 { margin: 0 0 10px 0; color: #047857; }
</style>';

global $wpdb;

echo '<div class="step">';
echo '<h3>📊 Current System Status</h3>';

// Check if we have events
$events_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_type = 'tribe_events' AND post_status = 'publish'");
echo '<p><strong>Events in system:</strong> ' . $events_count . '</p>';

// Check if we have snapshots
$snapshots_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_snapshots");
echo '<p><strong>Snapshots collected:</strong> ' . $snapshots_count . '</p>';

// Check if we have actuals
$actuals_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_actuals");
echo '<p><strong>Events with actuals:</strong> ' . $actuals_count . '</p>';

// Check if we have event features
$features_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_features");
echo '<p><strong>Events with features:</strong> ' . $features_count . '</p>';

echo '</div>';

echo '<div class="step">';
echo '<h3>🎯 What You Need for Forecasting</h3>';
echo '<p>For auto forecasting to work, you need:</p>';
echo '<ol>';
echo '<li><strong>Historical Events:</strong> Past events with recorded actuals</li>';
echo '<li><strong>Snapshots:</strong> Sales data captured at regular intervals</li>';
echo '<li><strong>Cohorts:</strong> Similar events for comparison</li>';
echo '</ol>';
echo '</div>';

echo '<div class="step">';
echo '<h3>🔄 How to Get Started</h3>';
echo '<p><strong>Option 1: Manual Planning (Immediate)</strong></p>';
echo '<ul>';
echo '<li>Use "Manual Estimate" mode in the planning modal</li>';
echo '<li>Enter expected attendance and tables</li>';
echo '<li>Get staffing recommendations immediately</li>';
echo '<li>Save the plan</li>';
echo '</ul>';

echo '<p><strong>Option 2: Build Historical Data (Future)</strong></p>';
echo '<ul>';
echo '<li>Record actuals after each event</li>';
echo '<li>Let snapshots collect sales data automatically</li>';
echo '<li>After 5-10 events, auto forecasting will start working</li>';
echo '</ul>';
echo '</div>';

echo '<div class="step">';
echo '<h3>📈 Current Event Status</h3>';

// Check event 256352 specifically
$event_id = 256352;
$event = get_post($event_id);
if ($event) {
    echo '<p><strong>Event 256352:</strong> ' . $event->post_title . '</p>';
    
    // Check if it has features
    $features = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}coco_event_features WHERE event_id = %d",
        $event_id
    ));
    
    if ($features) {
        echo '<p class="success">✅ Event has features (venue, weekday, etc.)</p>';
    } else {
        echo '<p class="warning">⚠️ Event missing features - this is needed for forecasting</p>';
    }
    
    // Check if it has snapshots
    $snapshots = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}coco_event_snapshots WHERE event_id = %d ORDER BY snapshot_ts DESC",
        $event_id
    ));
    
    if ($snapshots) {
        echo '<p class="success">✅ Event has ' . count($snapshots) . ' snapshots</p>';
        echo '<p>Latest snapshot: ' . $snapshots[0]->snapshot_ts . '</p>';
    } else {
        echo '<p class="warning">⚠️ No snapshots yet - will be created automatically</p>';
    }
    
    // Check if it has actuals
    $actuals = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}coco_event_actuals WHERE event_id = %d",
        $event_id
    ));
    
    if ($actuals) {
        echo '<p class="success">✅ Event has actuals recorded</p>';
    } else {
        echo '<p class="info">ℹ️ No actuals yet - record these after the event</p>';
    }
} else {
    echo '<p class="error">❌ Event 256352 not found</p>';
}

echo '</div>';

echo '<div class="step">';
echo '<h3>🚀 Quick Actions</h3>';
echo '<p><strong>For immediate use:</strong></p>';
echo '<ol>';
echo '<li>Go to Events page</li>';
echo '<li>Click "Plan" on any event</li>';
echo '<li>Use "Manual Estimate" mode</li>';
echo '<li>Enter expected attendance (e.g., 150)</li>';
echo '<li>Click "Compute Staffing"</li>';
echo '<li>Save the plan</li>';
echo '</ol>';

echo '<p><strong>For future forecasting:</strong></p>';
echo '<ol>';
echo '<li>After each event, click "Actuals"</li>';
echo '<li>Record final attendance and staff used</li>';
echo '<li>Save the actuals</li>';
echo '<li>Repeat for 5-10 events</li>';
echo '<li>Auto forecasting will then work!</li>';
echo '</ol>';
echo '</div>';

echo '<hr>';
echo '<p style="color: #6B7280; font-size: 14px;">The system is working correctly - you just need to build up historical data for auto forecasting to work.</p>';
?>
