<?php
// Script to regenerate a report with auto-forecast data
// Access via: yoursite.com/wp-content/plugins/coco-ops-forecast/regenerate-report.php

// Load WordPress
require_once('../../../wp-load.php');

if (!defined('ABSPATH')) {
    echo "Failed to load WordPress.\n";
    exit;
}

global $wpdb;

echo "=== REGENERATING REPORT WITH AUTO-FORECAST ===\n";

// Get the latest actuals entry
$latest_actuals = $wpdb->get_row("
    SELECT * FROM {$wpdb->prefix}coco_event_actuals 
    ORDER BY entered_at DESC 
    LIMIT 1
");

if (!$latest_actuals) {
    echo "No actuals found.\n";
    exit;
}

echo "Regenerating report for event: {$latest_actuals->event_id}\n";

// Get event details
$event = $wpdb->get_row($wpdb->prepare(
    "SELECT p.ID, p.post_title, pm_start.meta_value as start_date, pm_venue.meta_value as venue_id
     FROM {$wpdb->posts} p
     LEFT JOIN {$wpdb->postmeta} pm_start ON p.ID = pm_start.post_id AND pm_start.meta_key = '_EventStartDate'
     LEFT JOIN {$wpdb->postmeta} pm_venue ON p.ID = pm_venue.post_id AND pm_venue.meta_key = '_EventVenueID'
     WHERE p.ID = %d",
    $latest_actuals->event_id
));

if (!$event) {
    echo "Event not found.\n";
    exit;
}

echo "Event: {$event->post_title}\n";
echo "Venue ID: {$event->venue_id}\n";

// Prepare actuals data
$actuals_data = [
    'final_attendance' => $latest_actuals->final_attendance,
    'final_revenue' => $latest_actuals->final_revenue,
    'actual_bartenders' => $latest_actuals->actual_bartenders,
    'actual_bottle_girls' => $latest_actuals->actual_bottle_girls,
    'actual_wait' => $latest_actuals->actual_wait,
    'actual_security' => $latest_actuals->actual_security,
    'actual_managers' => $latest_actuals->actual_managers,
    'notes' => $latest_actuals->notes
];

// Delete existing report
$wpdb->delete(
    $wpdb->prefix . 'coco_event_reports',
    ['event_id' => $latest_actuals->event_id]
);
echo "Deleted existing report.\n";

// Generate new report
try {
    $report_generator = new Coco_Ops_Post_Event_Report();
    $report = $report_generator->generate_report($latest_actuals->event_id, $actuals_data);
    
    if ($report) {
        echo "Report regenerated successfully!\n";
        echo "Forecast source: " . ($report['forecast']['source'] ?? 'unknown') . "\n";
        echo "Planned attendance: " . ($report['forecast']['planned_attendance'] ?? 'N/A') . "\n";
        echo "Planned revenue: £" . ($report['forecast']['planned_revenue'] ?? 'N/A') . "\n";
        echo "Forecast accuracy: " . ($report['metrics']['attendance_accuracy'] ?? 'N/A') . "%\n";
    } else {
        echo "Failed to generate report.\n";
    }
    
} catch (Exception $e) {
    echo "Error generating report: " . $e->getMessage() . "\n";
}

echo "\n=== REGENERATION COMPLETE ===\n";
echo "Check the Debug Reports page to see the updated data.\n";
?>
