<?php
// Example: How the forecasting engine predicts final ticket sales
require_once('../../../wp-config.php');

echo "🎯 Forecasting Final Ticket Sales - Example\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

echo "📊 Scenario: Event is 7 days away with 11 tickets sold\n";
echo "Question: How many tickets will be sold by event day?\n\n";

echo "🔍 How the Forecasting Engine Works:\n\n";

echo "1️⃣ Current Event Data:\n";
echo "   - Current tickets sold: 11\n";
echo "   - Days to event: 7\n";
echo "   - Current snapshot: D-7\n\n";

echo "2️⃣ Cohort Analysis:\n";
echo "   - Find similar past events (same venue, day, time)\n";
echo "   - Look at their sales at D-7 (same point in time)\n";
echo "   - Look at their final sales (D+1 snapshots)\n\n";

echo "3️⃣ Pacing Calculation:\n";
echo "   - Event A: 10 tickets at D-7 → 50 tickets final = 5.0x ratio\n";
echo "   - Event B: 15 tickets at D-7 → 75 tickets final = 5.0x ratio\n";
echo "   - Event C: 8 tickets at D-7 → 40 tickets final = 5.0x ratio\n";
echo "   - Event D: 12 tickets at D-7 → 60 tickets final = 5.0x ratio\n";
echo "   - Event E: 20 tickets at D-7 → 100 tickets final = 5.0x ratio\n\n";

echo "4️⃣ Forecast Calculation:\n";
echo "   - P50 ratio: 5.0x (median of ratios)\n";
echo "   - P25 ratio: 4.5x (25th percentile)\n";
echo "   - P75 ratio: 5.5x (75th percentile)\n\n";

echo "5️⃣ Final Prediction:\n";
echo "   - P50 forecast: 11 × 5.0 = 55 tickets\n";
echo "   - P25 forecast: 11 × 4.5 = 50 tickets\n";
echo "   - P75 forecast: 11 × 5.5 = 61 tickets\n\n";

echo "✅ Result: The event is predicted to sell 55 tickets (range: 50-61)\n";
echo "   This means 44 more tickets are expected to be sold in the next 7 days\n\n";

echo "🎯 Key Points:\n";
echo "   - Uses historical pacing patterns from similar events\n";
echo "   - Accounts for the fact that most sales happen closer to event date\n";
echo "   - Provides confidence intervals (P25, P50, P75)\n";
echo "   - Updates as new snapshots are taken\n\n";

echo "📈 This is exactly what the forecasting engine does!\n";
echo "   It looks at how similar events performed at the same point in time\n";
echo "   and predicts the final outcome based on historical patterns.\n";

echo "\n✅ Example complete.\n";
?>
