<?php
/**
 * Simple fix for missing ruleset
 * Visit: /wp-content/plugins/coco-ops-forecast/fix-rules-simple.php
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🔧 Simple Ruleset Fix</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
</style>';

try {
    global $wpdb;
    
    // Check if rulesets table exists
    $table_rulesets = $wpdb->prefix . 'coco_rulesets';
    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_rulesets'");
    
    if (!$table_exists) {
        echo '<p class="error">❌ Rulesets table does not exist. Please activate the plugin first.</p>';
        exit;
    }
    
    // Check if ruleset exists
    $existing = $wpdb->get_var("SELECT COUNT(*) FROM $table_rulesets WHERE active = 1");
    
    if ($existing > 0) {
        echo '<p class="info">✅ Ruleset already exists!</p>';
        
        // Show current ruleset
        $ruleset = $wpdb->get_row("SELECT * FROM $table_rulesets WHERE active = 1 ORDER BY created_at DESC LIMIT 1");
        echo '<h2>Current Ruleset:</h2>';
        echo '<p><strong>Name:</strong> ' . esc_html($ruleset->name) . '</p>';
        echo '<p><strong>Version:</strong> ' . esc_html($ruleset->version) . '</p>';
        
    } else {
        echo '<p class="error">❌ No active ruleset found!</p>';
        echo '<p>Creating default ruleset...</p>';
        
        // Simple YAML content
        $yaml_content = "version: 1.0.0
rules:
  security:
    base_ratio: 0.022
    weekend_multiplier: 1.15
    weekday_min: 1
    weekend_min: 2
    max_count: 20
    
  bartenders:
    base_ratio: 0.023
    weekend_multiplier: 1.20
    min_count: 2
    max_count: 4
    
  wait_staff:
    base_ratio: 0.008
    weekend_multiplier: 1.50
    min_count: 1
    max_count: 15
    
  bottle_girls:
    base_ratio: 0.010
    weekend_multiplier: 1.15
    min_count: 0
    max_count: 10
    
  managers:
    base_ratio: 0.002
    weekend_multiplier: 1.00
    min_count: 1
    max_count: 1
    weekday_substitution: true";
        
        $result = $wpdb->insert(
            $table_rulesets,
            [
                'name' => 'Default Staffing Rules v1.0',
                'version' => '1.0.0',
                'yaml_content' => $yaml_content,
                'active' => 1,
                'created_at' => current_time('mysql')
            ],
            ['%s', '%s', '%s', '%d', '%s']
        );
        
        if ($result) {
            echo '<p class="success">✅ Default ruleset created successfully!</p>';
        } else {
            echo '<p class="error">❌ Failed to create ruleset: ' . $wpdb->last_error . '</p>';
        }
    }
    
} catch (Exception $e) {
    echo '<p class="error">❌ Error: ' . $e->getMessage() . '</p>';
}

echo '<hr>';
echo '<p style="color: #666; font-size: 12px;">Delete this file after fixing.</p>';
?>
