<?php
/**
 * One-time fix to add capabilities to administrator role
 * 
 * Instructions:
 * 1. Visit this file in your browser: /wp-content/plugins/coco-ops-forecast/fix-permissions.php
 * 2. You should see "Capabilities added successfully!"
 * 3. Delete this file after running
 */

// Load WordPress
require_once('../../../wp-load.php');

// Check if user is admin
if (!current_user_can('manage_options')) {
    die('You must be logged in as an administrator to run this script.');
}

// Add capabilities to administrator role
$admin_role = get_role('administrator');
if ($admin_role) {
    $admin_role->add_cap('coco_ops_view');
    $admin_role->add_cap('coco_ops_admin');
    echo '<h2>✅ Capabilities added successfully!</h2>';
    echo '<p>The following capabilities were added to the administrator role:</p>';
    echo '<ul>';
    echo '<li><code>coco_ops_view</code></li>';
    echo '<li><code>coco_ops_admin</code></li>';
    echo '</ul>';
} else {
    echo '<h2>❌ Error: Administrator role not found</h2>';
}

// Add view capability to editor role
$editor_role = get_role('editor');
if ($editor_role) {
    $editor_role->add_cap('coco_ops_view');
    echo '<p>Also added <code>coco_ops_view</code> capability to the editor role.</p>';
}

echo '<hr>';
echo '<h3>Next Steps:</h3>';
echo '<ol>';
echo '<li>Go to your WordPress admin: <a href="' . admin_url() . '">Admin Dashboard</a></li>';
echo '<li>Navigate to <strong>Ops Forecast → Events</strong></li>';
echo '<li>The page should now load with your events</li>';
echo '<li><strong>Delete this file (fix-permissions.php) after confirming it works</strong></li>';
echo '</ol>';

echo '<hr>';
echo '<h3>Test API Endpoints:</h3>';
echo '<ul>';
echo '<li><a href="' . rest_url('coco-ops/v1/events') . '" target="_blank">Test Events API</a></li>';
echo '<li><a href="' . rest_url('coco-ops/v1/venues') . '" target="_blank">Test Venues API</a></li>';
echo '<li><a href="' . rest_url('coco-ops/v1/settings') . '" target="_blank">Test Settings API</a></li>';
echo '</ul>';

echo '<p style="color: #666; font-size: 12px; margin-top: 40px;">You can safely delete this file now.</p>';
?>
