<?php
// Fix event 250474 by adding it to event features
require_once('../../../wp-config.php');

$event_id = 250474;

echo "🔧 Fixing Event 250474\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Get event details
$start_date = get_post_meta($event_id, '_EventStartDate', true);
$venue_id = get_post_meta($event_id, '_EventVenueID', true);

echo "Event Details:\n";
echo "Start Date: $start_date\n";
echo "Venue ID: $venue_id\n\n";

if (!$start_date || !$venue_id) {
    echo "❌ Missing required event data\n";
    exit;
}

// Calculate features
$start_ts = new DateTime($start_date);
$weekday = strtolower($start_ts->format('l'));

// Determine time bucket
$hour = (int) $start_ts->format('H');
if ($hour < 12) {
    $time_bucket = 'morning';
} elseif ($hour < 17) {
    $time_bucket = 'afternoon';
} elseif ($hour < 21) {
    $time_bucket = 'evening';
} elseif ($hour < 23) {
    $time_bucket = 'night';
} else {
    $time_bucket = 'late_night';
}

echo "Calculated Features:\n";
echo "Weekday: $weekday\n";
echo "Time Bucket: $time_bucket\n";
echo "Start TS: $start_date\n\n";

// Insert into event features table
$table = $wpdb->prefix . 'coco_event_features';

$result = $wpdb->insert(
    $table,
    [
        'event_id' => $event_id,
        'venue_id' => $venue_id,
        'weekday' => $weekday,
        'time_bucket' => $time_bucket,
        'start_ts' => $start_date,
        'created_at' => current_time('mysql')
    ],
    ['%d', '%d', '%s', '%s', '%s', '%s']
);

if ($result) {
    echo "✅ Successfully added event to features table\n";
    echo "Insert ID: " . $wpdb->insert_id . "\n";
} else {
    echo "❌ Failed to insert: " . $wpdb->last_error . "\n";
}

// Verify insertion
$check = $wpdb->get_row($wpdb->prepare("
    SELECT * FROM $table WHERE event_id = %d
", $event_id));

if ($check) {
    echo "\n✅ Verification successful:\n";
    foreach ($check as $key => $value) {
        echo "- $key: $value\n";
    }
} else {
    echo "\n❌ Verification failed\n";
}

echo "\n✅ Fix complete.\n";
?>
