<?php
// Debug the sales query for event 250474
require_once('../../../wp-config.php');

$event_id = 250474;

echo "🔍 Debugging Sales Query for Event $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// 1. Check all orders for this event using HPOS
echo "1️⃣ All Orders (HPOS - No Status Filter):\n";
$all_orders = $wpdb->get_results($wpdb->prepare("
    SELECT 
        wc_orders.id as order_id,
        wc_orders.status,
        pm_price.meta_value as ticket_price,
        CAST(COALESCE(oim_qty.meta_value, 1) AS SIGNED) as quantity,
        CAST(COALESCE(oim_line_total.meta_value, 0) AS DECIMAL(10,2)) as line_total
    FROM {$wpdb->prefix}wc_orders wc_orders
    INNER JOIN {$wpdb->prefix}woocommerce_order_items wc_order_items ON (
        wc_orders.id = wc_order_items.order_id
        AND wc_order_items.order_item_type = 'line_item'
    )
    INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim_ticket ON (
        wc_order_items.order_item_id = oim_ticket.order_item_id
        AND oim_ticket.meta_key = '_product_id'
    )
    INNER JOIN {$wpdb->posts} p_ticket ON (
        oim_ticket.meta_value = p_ticket.ID
        AND p_ticket.post_type = 'product'
    )
    INNER JOIN {$wpdb->postmeta} pm_price ON (
        p_ticket.ID = pm_price.post_id
        AND pm_price.meta_key = '_price'
    )
    INNER JOIN {$wpdb->postmeta} pm_event ON (
        p_ticket.ID = pm_event.post_id
        AND pm_event.meta_key = '_tribe_wooticket_for_event'
    )
    LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim_qty ON (
        wc_order_items.order_item_id = oim_qty.order_item_id
        AND oim_qty.meta_key = '_qty'
    )
    LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim_line_total ON (
        wc_order_items.order_item_id = oim_line_total.order_item_id
        AND oim_line_total.meta_key = '_line_total'
    )
    WHERE pm_event.meta_value = %d
    LIMIT 10
", $event_id));

echo "Found " . count($all_orders) . " orders\n";
foreach ($all_orders as $order) {
    echo "- Order {$order->order_id}: Status={$order->status}, Price=£{$order->ticket_price}, Qty={$order->quantity}, Total=£{$order->line_total}\n";
}

// 2. Check with different status filters
echo "\n2️⃣ Orders by Status:\n";
$statuses = ['wc-completed', 'wc-processing', 'completed', 'processing'];
foreach ($statuses as $status) {
    $count = $wpdb->get_var($wpdb->prepare("
        SELECT COUNT(*)
        FROM {$wpdb->prefix}wc_orders o
        JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id AND oi.meta_key = '_tribe_wooticket_for_event'
        WHERE oi.meta_value = %s AND o.status = %s
    ", $event_id, $status));
    echo "- Status '$status': $count orders\n";
}

// 3. Check what statuses actually exist
echo "\n3️⃣ Actual Order Statuses:\n";
$actual_statuses = $wpdb->get_results($wpdb->prepare("
    SELECT o.status, COUNT(*) as count
    FROM {$wpdb->prefix}wc_orders o
    JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id AND oi.meta_key = '_tribe_wooticket_for_event'
    WHERE oi.meta_value = %s
    GROUP BY o.status
", $event_id));

foreach ($actual_statuses as $status) {
    echo "- '{$status->status}': {$status->count} orders\n";
}

// 4. Check the get_historical_sales_data function approach
echo "\n4️⃣ Using get_historical_sales_data Function:\n";
try {
    require_once('coco-ops-forecast.php');
    $sales_data = get_historical_sales_data($event_id, date('Y-m-d H:i:s'));
    echo "Function result: " . json_encode($sales_data) . "\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

// 5. Check if there are any orders at all for this event
echo "\n5️⃣ Raw Order Check:\n";
$raw_orders = $wpdb->get_results($wpdb->prepare("
    SELECT o.id, o.status, oi.meta_key, oi.meta_value
    FROM {$wpdb->prefix}wc_orders o
    JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id
    WHERE oi.meta_key = '_tribe_wooticket_for_event'
    AND oi.meta_value = %s
    LIMIT 5
", $event_id));

echo "Raw orders with event meta: " . count($raw_orders) . "\n";
foreach ($raw_orders as $order) {
    echo "- Order {$order->id}: Status={$order->status}, Meta={$order->meta_key}={$order->meta_value}\n";
}

echo "\n✅ Debug complete.\n";
?>
