<?php
/**
 * Debug rules engine output
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🔍 Debug Rules Engine Output</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
    pre { background: #f5f5f5; padding: 10px; border-radius: 5px; }
</style>';

global $wpdb;

try {
    // Get the event with planning data
    $table_planning = $wpdb->prefix . 'coco_event_planning';
    $planning_event = $wpdb->get_row("SELECT * FROM $table_planning WHERE est_attendance > 0 LIMIT 1");
    
    if (!$planning_event) {
        echo '<p class="error">❌ No planning data found</p>';
        exit;
    }
    
    $event_id = $planning_event->event_id;
    echo '<p>Testing with event ' . $event_id . '</p>';
    echo '<p>Planning data: ' . $planning_event->est_attendance . ' people, ' . $planning_event->est_tables . ' tables</p>';
    
    // Get event features
    $table_features = $wpdb->prefix . 'coco_event_features';
    $features = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $table_features WHERE event_id = %d",
        $event_id
    ));
    
    if (!$features) {
        echo '<p class="error">❌ No event features found</p>';
        exit;
    }
    
    echo '<p>Weekday: ' . $features->weekday . ', Start bucket: ' . $features->start_bucket . '</p>';
    
    // Test rules engine and show full output
    echo '<h2>🧮 Rules Engine Full Output</h2>';
    $rules_engine = new Coco_Ops_Rules_Engine();
    $result = $rules_engine->compute_staffing(
        $planning_event->est_attendance,
        [
            'weekday' => $features->weekday,
            'start_bucket' => $features->start_bucket
        ],
        $planning_event->est_tables ?? 0
    );
    
    echo '<h3>Full Result Structure:</h3>';
    echo '<pre>' . print_r($result, true) . '</pre>';
    
    // Check if staffing exists and what format it's in
    if (isset($result['staffing'])) {
        echo '<h3>Staffing Structure:</h3>';
        echo '<pre>' . print_r($result['staffing'], true) . '</pre>';
        
        // Try to access the counts
        echo '<h3>Individual Role Counts:</h3>';
        foreach ($result['staffing'] as $role => $data) {
            echo '<p><strong>' . ucwords(str_replace('_', ' ', $role)) . ':</strong> ';
            if (is_array($data) && isset($data['count'])) {
                echo $data['count'];
            } elseif (is_numeric($data)) {
                echo $data;
            } else {
                echo 'Unknown format: ' . print_r($data, true);
            }
            echo '</p>';
        }
    } else {
        echo '<p class="error">❌ No staffing data in result</p>';
    }
    
    // Check if there's an error
    if (isset($result['error'])) {
        echo '<p class="error">❌ Rules engine error: ' . $result['error'] . '</p>';
    }
    
} catch (Exception $e) {
    echo '<p class="error">❌ Error: ' . $e->getMessage() . '</p>';
    echo '<pre>' . $e->getTraceAsString() . '</pre>';
}

echo '<hr>';
echo '<p>Debug complete.</p>';
?>
