<?php
// Debug script to check reports data
require_once 'coco-ops-forecast.php';

global $wpdb;

echo "=== REPORTS DEBUG ===\n";

// Check if reports table exists
$table_reports = $wpdb->prefix . 'coco_event_reports';
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_reports'");

echo "Reports table exists: " . ($table_exists ? 'YES' : 'NO') . "\n";

if ($table_exists) {
    $count = $wpdb->get_var("SELECT COUNT(*) FROM $table_reports");
    echo "Reports count: $count\n";
    
    if ($count > 0) {
        $sample = $wpdb->get_row("SELECT * FROM $table_reports ORDER BY generated_at DESC LIMIT 1");
        echo "Sample report:\n";
        print_r($sample);
    }
} else {
    echo "Creating reports table...\n";
    $report_generator = new Coco_Ops_Post_Event_Report();
    $report_generator->create_reports_table();
    echo "Reports table created.\n";
}

// Check if we have any actuals data
$table_actuals = $wpdb->prefix . 'coco_event_actuals';
$actuals_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_actuals");
echo "\nActuals count: $actuals_count\n";

if ($actuals_count > 0) {
    $sample_actuals = $wpdb->get_row("SELECT * FROM $table_actuals ORDER BY entered_at DESC LIMIT 1");
    echo "Sample actuals:\n";
    print_r($sample_actuals);
    
    // Check if this actuals entry has a corresponding report
    if ($table_exists) {
        $report_exists = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM $table_reports WHERE event_id = %d",
            $sample_actuals->event_id
        ));
        echo "Report exists for this actuals entry: " . ($report_exists ? 'YES' : 'NO') . "\n";
    }
} else {
    echo "No actuals data found. You need to save actuals for events first.\n";
}

// Check events with planning data
$table_planning = $wpdb->prefix . 'coco_event_planning';
$planning_count = $wpdb->get_var("SELECT COUNT(*) FROM $table_planning");
echo "\nPlanning entries count: $planning_count\n";

if ($planning_count > 0) {
    $sample_planning = $wpdb->get_row("SELECT * FROM $table_planning ORDER BY created_at DESC LIMIT 1");
    echo "Sample planning:\n";
    print_r($sample_planning);
}

echo "\n=== END DEBUG ===\n";
?>
