<?php
// Debug script to check report data
// This should be accessed via WordPress admin or wp-cli

// Load WordPress
require_once('../../../wp-load.php');

// Check if we're in WordPress context
if (!defined('ABSPATH')) {
    echo "Failed to load WordPress. Please check the path.\n";
    exit;
}

global $wpdb;

echo "=== DEBUGGING REPORT DATA ===\n";

// Get the latest report
$latest_report = $wpdb->get_row("
    SELECT * FROM {$wpdb->prefix}coco_event_reports 
    ORDER BY generated_at DESC 
    LIMIT 1
");

if (!$latest_report) {
    echo "No reports found.\n";
    exit;
}

echo "Latest report:\n";
echo "Event ID: {$latest_report->event_id}\n";
echo "Event Title: {$latest_report->event_title}\n";
echo "Venue ID: {$latest_report->venue_id}\n";
echo "Event Date: {$latest_report->event_date}\n";

// Check if venue exists
if ($latest_report->venue_id) {
    $venue_post = get_post($latest_report->venue_id);
    if ($venue_post) {
        echo "Venue Name: {$venue_post->post_title}\n";
    } else {
        echo "Venue not found for ID: {$latest_report->venue_id}\n";
    }
}

// Parse report data
$report_data = json_decode($latest_report->report_data, true);
echo "\nReport Data:\n";
echo "Actuals: " . json_encode($report_data['actuals'] ?? [], JSON_PRETTY_PRINT) . "\n";
echo "Forecast: " . json_encode($report_data['forecast'] ?? [], JSON_PRETTY_PRINT) . "\n";
echo "Metrics: " . json_encode($report_data['metrics'] ?? [], JSON_PRETTY_PRINT) . "\n";

// Check if there's planning data for this event
$planning = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}coco_event_planning WHERE event_id = %d",
    $latest_report->event_id
));

echo "\nPlanning Data:\n";
if ($planning) {
    echo "Found planning data:\n";
    echo "Est Attendance: {$planning->est_attendance}\n";
    echo "Est Revenue: {$planning->est_revenue}\n";
    echo "Est Tables: {$planning->est_tables}\n";
} else {
    echo "No planning data found for this event.\n";
    echo "This is why forecast accuracy is 0%.\n";
}

// Check if there are any events with planning data
$planning_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}coco_event_planning");
echo "\nTotal planning entries: $planning_count\n";

if ($planning_count > 0) {
    $sample_planning = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}coco_event_planning ORDER BY created_at DESC LIMIT 1");
    echo "Sample planning entry:\n";
    echo "Event ID: {$sample_planning->event_id}\n";
    echo "Est Attendance: {$sample_planning->est_attendance}\n";
}

echo "\n=== END DEBUG ===\n";
?>
