<?php
// Debug specific event forecast
require_once('../../../wp-config.php');

$event_id = 250474; // Cite - Afrobeats Saturdays at Cococure Cite

echo "🔍 Debugging Event Forecast\n";
echo "Event ID: $event_id\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Get event details
$event = $wpdb->get_row($wpdb->prepare("
    SELECT p.post_title, p.post_date, pm.meta_value as start_ts
    FROM {$wpdb->posts} p
    LEFT JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_EventStartDate'
    WHERE p.ID = %d
", $event_id));

if ($event) {
    echo "Event: " . $event->post_title . "\n";
    echo "Event Date: " . $event->start_ts . "\n";
    echo "Days to event: " . round((strtotime($event->start_ts) - time()) / 86400, 1) . "\n\n";
}

// Get current sales data
$current_sales = $wpdb->get_row($wpdb->prepare("
    SELECT tickets_sold, tables_sold, revenue_to_date
    FROM {$wpdb->prefix}coco_event_snapshots
    WHERE event_id = %d
    ORDER BY snapshot_date DESC
    LIMIT 1
", $event_id));

echo "Current Sales (from snapshot):\n";
echo "Tickets: " . ($current_sales->tickets_sold ?? 'N/A') . "\n";
echo "Tables: " . ($current_sales->tables_sold ?? 'N/A') . "\n";
echo "Revenue: £" . ($current_sales->revenue_to_date ?? 'N/A') . "\n\n";

// Get live sales data
$live_sales = $wpdb->get_results($wpdb->prepare("
    SELECT 
        oi.meta_value as ticket_price,
        oi2.meta_value as quantity,
        oi3.meta_value as line_total
    FROM {$wpdb->prefix}wc_orders o
    JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id AND oi.meta_key = '_tribe_wooticket_for_event'
    JOIN {$wpdb->prefix}wc_orders_meta oi2 ON o.id = oi2.order_id AND oi2.meta_key = '_qty'
    JOIN {$wpdb->prefix}wc_orders_meta oi3 ON o.id = oi3.order_id AND oi3.meta_key = '_line_total'
    WHERE oi.meta_value = %s
    AND o.status IN ('wc-completed', 'wc-processing')
", $event_id));

$paid_tickets = 0;
$free_tickets = 0;
$table_entries = 0;
$total_tickets = 0;
$table_threshold = 100;

foreach ($live_sales as $sale) {
    $price = (float) $sale->ticket_price;
    $qty = (int) $sale->quantity;
    $line_total = (float) $sale->line_total;
    
    $total_tickets += $qty;
    
    if ($price >= $table_threshold) {
        $table_entries += $qty * 6; // Assuming 6 per table
    } elseif ($line_total > 0) {
        $paid_tickets += $qty;
    } else {
        $free_tickets += $qty;
    }
}

echo "Live Sales Breakdown:\n";
echo "Total tickets: $total_tickets\n";
echo "Paid tickets: $paid_tickets\n";
echo "Free tickets: $free_tickets\n";
echo "Table entries: $table_entries\n";
echo "Paid + table entries: " . ($paid_tickets + $table_entries) . "\n\n";

// Test the forecasting engine
try {
    require_once('includes/class-forecasting-engine.php');
    $forecasting_engine = new Coco_Ops_Forecasting_Engine();
    $forecast = $forecasting_engine->generate_forecast($event_id);
    
    if ($forecast && isset($forecast['forecast'])) {
        echo "Generated Forecast:\n";
        echo "Ticket sales p50: " . ($forecast['forecast']['ticket_sales_p50'] ?? 'N/A') . "\n";
        echo "Attendance p50: " . ($forecast['forecast']['attendance_p50'] ?? 'N/A') . "\n";
        echo "Revenue p50: £" . ($forecast['forecast']['revenue_p50'] ?? 'N/A') . "\n";
        echo "Confidence: " . ($forecast['forecast']['confidence'] ?? 'N/A') . "\n";
        echo "Cohort count: " . ($forecast['forecast']['cohort_count'] ?? 'N/A') . "\n\n";
        
        $forecast_tickets = $forecast['forecast']['ticket_sales_p50'] ?? 0;
        $minimum = $paid_tickets + $table_entries;
        
        echo "Rule Check:\n";
        echo "Forecast: $forecast_tickets\n";
        echo "Minimum (paid + tables): $minimum\n";
        
        if ($forecast_tickets >= $minimum) {
            echo "✅ Rule satisfied: Forecast >= minimum\n";
        } else {
            echo "❌ Rule violated: Forecast < minimum\n";
            echo "Expected forecast: $minimum\n";
        }
    } else {
        echo "Failed to generate forecast\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

// Check cohorts
echo "\n🔍 Cohort Analysis:\n";
try {
    require_once('includes/class-cohort-matcher.php');
    $cohort_matcher = new Coco_Ops_Cohort_Matcher();
    $cohorts = $cohort_matcher->find_cohorts($event_id);
    
    echo "Found " . count($cohorts) . " cohorts\n";
    
    if (!empty($cohorts)) {
        echo "Sample cohort events:\n";
        foreach (array_slice($cohorts, 0, 5) as $cohort) {
            echo "- Event ID: " . $cohort['event_id'] . " (Final sales: " . ($cohort['final_ticket_sales'] ?? 'N/A') . ")\n";
        }
    }
    
} catch (Exception $e) {
    echo "Cohort error: " . $e->getMessage() . "\n";
}

echo "\nDebug complete.\n";
?>
