<?php
/**
 * Debug Event 243315 - Check ticket count discrepancy
 */

// Include WordPress
require_once('../../../wp-config.php');

global $wpdb;

echo "🔍 Debugging Event 243315\n";
echo "Time: " . current_time('mysql') . "\n\n";

$event_id = 243315;

// Get event details
$event = $wpdb->get_row($wpdb->prepare(
    "SELECT p.ID, p.post_title, pm_start.meta_value as start_date
     FROM {$wpdb->posts} p
     LEFT JOIN {$wpdb->postmeta} pm_start ON p.ID = pm_start.post_id AND pm_start.meta_key = '_EventStartDate'
     WHERE p.ID = %d",
    $event_id
));

if (!$event) {
    echo "❌ Event not found\n";
    exit;
}

echo "📅 Event: {$event->post_title}\n";
echo "📅 Start Date: {$event->start_date}\n\n";

// Calculate 14 days before event
$event_start = new DateTime($event->start_date);
$snapshot_cutoff = $event_start->modify('-14 days');
$cutoff_date = $snapshot_cutoff->format('Y-m-d H:i:s');

echo "📊 Snapshot Cutoff (D-14): {$cutoff_date}\n\n";

// Get all ticket sales for this event (no date limit)
$all_sales = $wpdb->get_results($wpdb->prepare("
    SELECT 
        oi.order_item_name,
        oi.order_item_type,
        oi.qty,
        o.date_created as order_date,
        o.total
    FROM {$wpdb->prefix}woocommerce_order_items oi
    JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim ON oi.order_item_id = oim.order_item_id
    JOIN {$wpdb->prefix}wc_orders o ON oi.order_id = o.id
    WHERE oim.meta_key = '_tribe_wooticket_for_event' 
    AND oim.meta_value = %s
    AND o.status IN ('wc-completed', 'wc-processing')
    ORDER BY o.date_created ASC
", $event_id));

echo "🎫 All Ticket Sales (No Date Limit): " . count($all_sales) . " orders\n";

$total_tickets = 0;
$total_tables = 0;
$total_revenue = 0;

foreach ($all_sales as $sale) {
    $total_tickets += $sale->qty;
    $total_revenue += $sale->total;
    
    // Check if it's a table (price >= 100)
    if ($sale->total >= 100) {
        $total_tables += $sale->qty;
    }
    
    echo "  - {$sale->order_item_name}: {$sale->qty} qty, £{$sale->total} ({$sale->order_date})\n";
}

echo "\n📊 Total Summary:\n";
echo "  - Total Tickets: {$total_tickets}\n";
echo "  - Total Tables: {$total_tables}\n";
echo "  - Total Revenue: £{$total_revenue}\n\n";

// Get sales within 14-day window
$recent_sales = $wpdb->get_results($wpdb->prepare("
    SELECT 
        oi.order_item_name,
        oi.order_item_type,
        oi.qty,
        o.date_created as order_date,
        o.total
    FROM {$wpdb->prefix}woocommerce_order_items oi
    JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim ON oi.order_item_id = oim.order_item_id
    JOIN {$wpdb->prefix}wc_orders o ON oi.order_id = o.id
    WHERE oim.meta_key = '_tribe_wooticket_for_event' 
    AND oim.meta_value = %s
    AND o.status IN ('wc-completed', 'wc-processing')
    AND o.date_created >= %s
    ORDER BY o.date_created ASC
", $event_id, $cutoff_date));

echo "🎫 Recent Sales (D-14 to Event): " . count($recent_sales) . " orders\n";

$recent_tickets = 0;
$recent_tables = 0;
$recent_revenue = 0;

foreach ($recent_sales as $sale) {
    $recent_tickets += $sale->qty;
    $recent_revenue += $sale->total;
    
    if ($sale->total >= 100) {
        $recent_tables += $sale->qty;
    }
    
    echo "  - {$sale->order_item_name}: {$sale->qty} qty, £{$sale->total} ({$sale->order_date})\n";
}

echo "\n📊 Recent Summary (D-14 to Event):\n";
echo "  - Recent Tickets: {$recent_tickets}\n";
echo "  - Recent Tables: {$recent_tables}\n";
echo "  - Recent Revenue: £{$recent_revenue}\n\n";

// Check snapshots
$snapshots = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}coco_event_snapshots WHERE event_id = %d ORDER BY snapshot_ts DESC",
    $event_id
));

echo "📸 Snapshots: " . count($snapshots) . " found\n";
foreach ($snapshots as $snapshot) {
    echo "  - {$snapshot->snapshot_ts}: {$snapshot->tickets_sold} tickets, {$snapshot->tables_sold} tables, £{$snapshot->revenue_to_date}\n";
}

echo "\n🏁 Debug complete\n";
?>
