<?php
// Debug D+1 snapshots for forecasting
require_once('../../../wp-config.php');

echo "🔍 Debugging D+1 Snapshots for Forecasting\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check a few recent events to see their snapshot patterns
$recent_events = $wpdb->get_results("
    SELECT p.ID, p.post_title, pm.meta_value as start_date
    FROM {$wpdb->posts} p
    LEFT JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_EventStartDate'
    WHERE p.post_type = 'tribe_events'
    AND p.post_status = 'publish'
    AND pm.meta_value < NOW()
    ORDER BY pm.meta_value DESC
    LIMIT 5
");

echo "📅 Recent Events and Their Snapshots:\n";
foreach ($recent_events as $event) {
    echo "\nEvent: {$event->post_title} (ID: {$event->ID})\n";
    echo "Event Date: {$event->start_date}\n";
    
    // Get all snapshots for this event
    $snapshots = $wpdb->get_results($wpdb->prepare("
        SELECT snapshot_ts, days_to_event, tickets_sold, tables_sold, revenue_to_date
        FROM {$wpdb->prefix}coco_event_snapshots
        WHERE event_id = %d
        ORDER BY snapshot_ts ASC
    ", $event->ID));
    
    echo "Snapshots (" . count($snapshots) . "):\n";
    foreach ($snapshots as $snapshot) {
        $is_d1 = ($snapshot->days_to_event < 0 && abs($snapshot->days_to_event) <= 1);
        $marker = $is_d1 ? "🎯 D+1" : "   ";
        echo "  $marker {$snapshot->snapshot_ts}: D{$snapshot->days_to_event}, {$snapshot->tickets_sold} tix, £{$snapshot->revenue_to_date}\n";
    }
    
    // Check if we have D+1 snapshot
    $d1_snapshot = $wpdb->get_row($wpdb->prepare("
        SELECT snapshot_ts, days_to_event, tickets_sold, tables_sold, revenue_to_date
        FROM {$wpdb->prefix}coco_event_snapshots
        WHERE event_id = %d
        AND days_to_event < 0
        AND days_to_event >= -1
        ORDER BY snapshot_ts DESC
        LIMIT 1
    ", $event->ID));
    
    if ($d1_snapshot) {
        echo "✅ D+1 snapshot found: {$snapshot->tickets_sold} tickets\n";
    } else {
        echo "❌ No D+1 snapshot found\n";
    }
}

// Test the current forecasting logic
echo "\n🤖 Testing Current Forecasting Logic:\n";
$test_event_id = 250474; // Event we've been working with

echo "Testing with event $test_event_id:\n";

// Get cohort events
$event_features = $wpdb->get_row($wpdb->prepare("
    SELECT venue_id, weekday, time_bucket
    FROM {$wpdb->prefix}coco_event_features
    WHERE event_id = %d
", $test_event_id));

if ($event_features) {
    $cohorts = $wpdb->get_results($wpdb->prepare("
        SELECT ef.event_id, ef.start_ts, p.post_title
        FROM {$wpdb->prefix}coco_event_features ef
        LEFT JOIN {$wpdb->posts} p ON ef.event_id = p.ID
        WHERE ef.venue_id = %d
        AND ef.weekday = %s
        AND ef.time_bucket = %s
        AND ef.event_id != %d
        ORDER BY ef.start_ts DESC
        LIMIT 5
    ", $event_features->venue_id, $event_features->weekday, $event_features->time_bucket, $test_event_id));
    
    echo "Cohort events (" . count($cohorts) . "):\n";
    foreach ($cohorts as $cohort) {
        // Get final snapshot (current logic)
        $final_snapshot = $wpdb->get_row($wpdb->prepare("
            SELECT snapshot_ts, days_to_event, tickets_sold
            FROM {$wpdb->prefix}coco_event_snapshots
            WHERE event_id = %d
            ORDER BY snapshot_ts DESC
            LIMIT 1
        ", $cohort->event_id));
        
        // Get D+1 snapshot
        $d1_snapshot = $wpdb->get_row($wpdb->prepare("
            SELECT snapshot_ts, days_to_event, tickets_sold
            FROM {$wpdb->prefix}coco_event_snapshots
            WHERE event_id = %d
            AND days_to_event < 0
            AND days_to_event >= -1
            ORDER BY snapshot_ts DESC
            LIMIT 1
        ", $cohort->event_id));
        
        echo "- Event {$cohort->event_id}: ";
        if ($final_snapshot) {
            echo "Final: {$final_snapshot->tickets_sold} tix (D{$final_snapshot->days_to_event})";
        }
        if ($d1_snapshot) {
            echo " | D+1: {$d1_snapshot->tickets_sold} tix (D{$d1_snapshot->days_to_event})";
        }
        echo "\n";
    }
}

echo "\n✅ Debug complete.\n";
?>
