<?php
/**
 * Debug Cohort Matching
 */

// Include WordPress
require_once('../../../wp-config.php');

global $wpdb;

echo "🔍 Debugging Cohort Matching\n";
echo "Time: " . current_time('mysql') . "\n\n";

// Test with the current event
$event_id = 256352; // TWNTY7 - 29 Nights

echo "📅 Testing event ID: {$event_id}\n";

// Get event features
$features = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}coco_event_features WHERE event_id = %d",
    $event_id
));

if (!$features) {
    echo "❌ No event features found\n";
    exit;
}

echo "✅ Event features:\n";
echo "  - Venue: {$features->venue_id}\n";
echo "  - Weekday: {$features->weekday}\n";
echo "  - Start bucket: {$features->start_bucket}\n";
echo "  - Start time: {$features->start_ts}\n\n";

// Test cohort matching
echo "🔍 Testing cohort matching...\n";

try {
    $cohort_matcher = new Coco_Ops_Cohort_Matcher();
    
    // Test with different sensitivity levels
    $sensitivities = ['strict', 'medium', 'loose'];
    
    foreach ($sensitivities as $sensitivity) {
        echo "\n📊 Testing {$sensitivity} sensitivity:\n";
        
        $cohorts = $cohort_matcher->find_cohorts($event_id, 5, $sensitivity);
        
        echo "  - Found " . count($cohorts) . " cohorts\n";
        
        if (!empty($cohorts)) {
            echo "  - Top cohorts:\n";
            foreach (array_slice($cohorts, 0, 3) as $cohort) {
                echo "    * Event {$cohort['event_id']}: {$cohort['similarity_score']}% similar\n";
            }
        }
    }
    
    // Check what events are available for matching
    echo "\n📈 Available events for matching:\n";
    
    $available_events = $wpdb->get_results($wpdb->prepare("
        SELECT ef.event_id, ef.venue_id, ef.weekday, ef.start_bucket, ef.start_ts
        FROM {$wpdb->prefix}coco_event_features ef
        WHERE ef.event_id != %d
        AND ef.venue_id = %s
        ORDER BY ef.start_ts DESC
        LIMIT 10
    ", $event_id, $features->venue_id));
    
    echo "  - Events at same venue ({$features->venue_id}): " . count($available_events) . "\n";
    
    foreach ($available_events as $event) {
        echo "    * Event {$event->event_id}: {$event->weekday} {$event->start_bucket} ({$event->start_ts})\n";
    }
    
    // Check events with same weekday
    $weekday_events = $wpdb->get_results($wpdb->prepare("
        SELECT ef.event_id, ef.venue_id, ef.weekday, ef.start_bucket, ef.start_ts
        FROM {$wpdb->prefix}coco_event_features ef
        WHERE ef.event_id != %d
        AND ef.weekday = %s
        ORDER BY ef.start_ts DESC
        LIMIT 10
    ", $event_id, $features->weekday));
    
    echo "\n  - Events on same weekday ({$features->weekday}): " . count($weekday_events) . "\n";
    
    foreach ($weekday_events as $event) {
        echo "    * Event {$event->event_id}: {$event->venue_id} {$event->start_bucket} ({$event->start_ts})\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n🏁 Cohort debugging complete\n";
?>
