<?php
/**
 * Debug authentication issues
 * Visit: /wp-content/plugins/coco-ops-forecast/debug-auth.php
 */

require_once('../../../wp-load.php');

echo '<h1>🔍 Authentication Debug</h1>';

echo '<h2>Current User Info</h2>';
echo '<pre>';
echo 'User ID: ' . get_current_user_id() . "\n";
echo 'Username: ' . wp_get_current_user()->user_login . "\n";
echo 'Is logged in: ' . (is_user_logged_in() ? 'Yes' : 'No') . "\n";
echo 'Is admin: ' . (current_user_can('manage_options') ? 'Yes' : 'No') . "\n";
echo '</pre>';

echo '<h2>Capabilities Check</h2>';
echo '<pre>';
echo 'manage_options: ' . (current_user_can('manage_options') ? 'Yes' : 'No') . "\n";
echo 'coco_ops_view: ' . (current_user_can('coco_ops_view') ? 'Yes' : 'No') . "\n";
echo 'coco_ops_admin: ' . (current_user_can('coco_ops_admin') ? 'Yes' : 'No') . "\n";
echo 'edit_posts: ' . (current_user_can('edit_posts') ? 'Yes' : 'No') . "\n";
echo '</pre>';

echo '<h2>REST API Test</h2>';

// Test REST API endpoint directly
$request = new WP_REST_Request('GET', '/coco-ops/v1/events');
$response = rest_do_request($request);

echo '<h3>Events Endpoint Response:</h3>';
echo '<pre>';
if (is_wp_error($response)) {
    echo 'Error: ' . $response->get_error_message();
} else {
    $data = $response->get_data();
    if (isset($data['code'])) {
        echo 'Error Code: ' . $data['code'] . "\n";
        echo 'Message: ' . $data['message'] . "\n";
        echo 'Status: ' . $response->get_status() . "\n";
    } else {
        echo 'Success! Found ' . count($data) . ' events' . "\n";
        if (count($data) > 0) {
            echo 'First event: ' . $data[0]['title'] . "\n";
        }
    }
}
echo '</pre>';

echo '<h2>Nonce Test</h2>';
$nonce = wp_create_nonce('wp_rest');
echo '<pre>';
echo 'Generated nonce: ' . $nonce . "\n";
echo 'Nonce verification: ' . (wp_verify_nonce($nonce, 'wp_rest') ? 'Valid' : 'Invalid') . "\n";
echo '</pre>';

echo '<h2>REST API URL</h2>';
echo '<pre>';
echo rest_url('coco-ops/v1/events') . "\n";
echo '</pre>';

echo '<h2>Try API in Browser</h2>';
echo '<p><a href="' . rest_url('coco-ops/v1/events') . '" target="_blank">Open Events API</a></p>';
echo '<p><a href="' . rest_url('coco-ops/v1/venues') . '" target="_blank">Open Venues API</a></p>';

echo '<hr>';
echo '<p style="color: #666; font-size: 12px;">Delete this file after debugging</p>';
?>
