<?php
// Check snapshot table schema
require_once('../../../wp-config.php');

echo "🔍 Checking Snapshot Table Schema\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check table structure
$table_name = $wpdb->prefix . 'coco_event_snapshots';
$columns = $wpdb->get_results("DESCRIBE $table_name");

echo "Table: $table_name\n";
echo "Columns:\n";
foreach ($columns as $column) {
    echo "- {$column->Field} ({$column->Type})\n";
}

echo "\nSample data (last 5 records):\n";
$sample = $wpdb->get_results("
    SELECT event_id, snapshot_ts, days_to_event, tickets_sold, tables_sold, revenue_to_date
    FROM $table_name
    ORDER BY snapshot_ts DESC
    LIMIT 5
");

foreach ($sample as $row) {
    echo "- Event {$row->event_id}: {$row->snapshot_ts}, D{$row->days_to_event}, {$row->tickets_sold} tix, {$row->tables_sold} tables, £{$row->revenue_to_date}\n";
}

echo "\n✅ Schema check complete.\n";
?>
