<?php
// Check if ruleset exists and create one if needed
require_once('../../../wp-config.php');

echo "🔍 Checking Ruleset Status\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check if ruleset table exists
$table_name = $wpdb->prefix . 'coco_staffing_rulesets';
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name;

echo "1️⃣ Table Check:\n";
if ($table_exists) {
    echo "✅ Table $table_name exists\n";
} else {
    echo "❌ Table $table_name does not exist\n";
    echo "Creating table...\n";
    
    $sql = "CREATE TABLE $table_name (
        id int(11) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        yaml_content longtext NOT NULL,
        is_active tinyint(1) DEFAULT 0,
        created_at datetime DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    )";
    
    $result = $wpdb->query($sql);
    if ($result) {
        echo "✅ Table created successfully\n";
    } else {
        echo "❌ Failed to create table: " . $wpdb->last_error . "\n";
        exit;
    }
}

// Check for active ruleset
echo "\n2️⃣ Active Ruleset Check:\n";
$ruleset = $wpdb->get_row("
    SELECT * FROM $table_name 
    WHERE is_active = 1 
    ORDER BY created_at DESC 
    LIMIT 1
");

if ($ruleset) {
    echo "✅ Active ruleset found:\n";
    echo "- ID: {$ruleset->id}\n";
    echo "- Name: {$ruleset->name}\n";
    echo "- Created: {$ruleset->created_at}\n";
} else {
    echo "❌ No active ruleset found\n";
    echo "Creating default ruleset...\n";
    
    $default_yaml = "security:
  base_ratio: 0.022
  min_count: 1
  weekend_multiplier: 1.15
  rationale: '1 per 45 people (2.2%)'

bartenders:
  base_ratio: 0.023
  max_count: 4
  weekend_multiplier: 1.20
  rationale: '1 per 43 people (2.3%), max 4 due to bar space'

bottle_girls:
  base_ratio: 0.01
  weekend_multiplier: 1.15
  table_ratio: 0.3
  rationale: '1 per 100 people (1.0%) + 0.3 per table'

wait_staff:
  base_ratio: 0.008
  weekend_multiplier: 1.50
  table_ratio: 0.5
  rationale: '1 per 125 people (0.8%) + 0.5 per table'

managers:
  base_ratio: 0.002
  weekend_multiplier: 1.0
  rationale: '1 per 500 people (0.2%)'

special_rules:
  weekday_substitution:
    enabled: true
    condition: 'attendance < 40 and weekday != saturday and weekday != sunday'
    replace: 'bartenders'
    replace_count: 1
    with: 'managers'
    rationale: 'On weekdays with <40 people, use manager instead of 1 bartender'";

    $result = $wpdb->insert(
        $table_name,
        [
            'name' => 'Default Staffing Rules',
            'yaml_content' => $default_yaml,
            'is_active' => 1
        ],
        ['%s', '%s', '%d']
    );
    
    if ($result) {
        echo "✅ Default ruleset created successfully\n";
    } else {
        echo "❌ Failed to create ruleset: " . $wpdb->last_error . "\n";
    }
}

echo "\n✅ Check complete.\n";
?>
