<?php
// Check WooCommerce HPOS table structure
require_once('../../../wp-config.php');

echo "🔍 Checking WooCommerce HPOS Tables\n";
echo "Date: " . date('Y-m-d H:i:s') . "\n\n";

global $wpdb;

// Check if HPOS is enabled
$hpos_enabled = get_option('woocommerce_custom_orders_table_enabled');
echo "HPOS Enabled: " . ($hpos_enabled ? 'Yes' : 'No') . "\n\n";

// Check what tables exist
$tables_to_check = [
    $wpdb->prefix . 'wc_orders',
    $wpdb->prefix . 'wc_orders_meta',
    $wpdb->prefix . 'wc_order_product_lookup',
    $wpdb->prefix . 'wc_order_stats',
    $wpdb->prefix . 'wc_orders_meta',
    $wpdb->prefix . 'posts',
    $wpdb->prefix . 'postmeta'
];

echo "Table Existence Check:\n";
foreach ($tables_to_check as $table) {
    $exists = $wpdb->get_var("SHOW TABLES LIKE '$table'");
    echo "- $table: " . ($exists ? '✅ Exists' : '❌ Missing') . "\n";
}

// Check wc_orders table structure
echo "\n📊 wc_orders Table Structure:\n";
$columns = $wpdb->get_results("DESCRIBE {$wpdb->prefix}wc_orders");
foreach ($columns as $column) {
    echo "- {$column->Field} ({$column->Type})\n";
}

// Check wc_orders_meta table structure
echo "\n📊 wc_orders_meta Table Structure:\n";
$columns = $wpdb->get_results("DESCRIBE {$wpdb->prefix}wc_orders_meta");
foreach ($columns as $column) {
    echo "- {$column->Field} ({$column->Type})\n";
}

// Check wc_order_product_lookup table structure
echo "\n📊 wc_order_product_lookup Table Structure:\n";
$columns = $wpdb->get_results("DESCRIBE {$wpdb->prefix}wc_order_product_lookup");
foreach ($columns as $column) {
    echo "- {$column->Field} ({$column->Type})\n";
}

// Test query with HPOS tables
echo "\n🧪 Testing HPOS Query:\n";
$test_orders = $wpdb->get_results("
    SELECT o.id, o.status, o.type, o.date_created_gmt
    FROM {$wpdb->prefix}wc_orders o
    LIMIT 5
");

echo "Sample orders from wc_orders:\n";
foreach ($test_orders as $order) {
    echo "- Order {$order->id}: Status={$order->status}, Type={$order->type}, Date={$order->date_created_gmt}\n";
}

// Check if we can find orders with event products
echo "\n🔍 Testing Event Product Query:\n";
$event_orders = $wpdb->get_results("
    SELECT o.id, o.status, oi.meta_key, oi.meta_value
    FROM {$wpdb->prefix}wc_orders o
    JOIN {$wpdb->prefix}wc_orders_meta oi ON o.id = oi.order_id
    WHERE oi.meta_key = '_tribe_wooticket_for_event'
    LIMIT 5
");

echo "Orders with event products:\n";
foreach ($event_orders as $order) {
    echo "- Order {$order->id}: Status={$order->status}, Meta={$order->meta_key}={$order->meta_value}\n";
}

echo "\n✅ HPOS check complete.\n";
?>
