<?php
/**
 * Check database tables
 * Visit: /wp-content/plugins/coco-ops-forecast/check-database.php
 */

require_once('../../../wp-load.php');

if (!current_user_can('manage_options')) {
    die('Unauthorized');
}

echo '<h1>🔍 Database Check</h1>';
echo '<style>
    body { font-family: system-ui; padding: 20px; }
    .success { color: #059669; }
    .error { color: #DC2626; }
    .info { color: #3B82F6; }
</style>';

global $wpdb;

// Check if tables exist
$tables = [
    'coco_event_features',
    'coco_event_snapshots', 
    'coco_event_planning',
    'coco_staffing_recs',
    'coco_event_actuals',
    'coco_rulesets'
];

echo '<h2>Database Tables Status:</h2>';
foreach ($tables as $table) {
    $full_table = $wpdb->prefix . $table;
    $exists = $wpdb->get_var("SHOW TABLES LIKE '$full_table'");
    
    if ($exists) {
        $count = $wpdb->get_var("SELECT COUNT(*) FROM $full_table");
        echo "<p class='success'>✅ {$table}: Exists ({$count} rows)</p>";
    } else {
        echo "<p class='error'>❌ {$table}: Missing</p>";
    }
}

echo '<h2>Rulesets:</h2>';
$table_rulesets = $wpdb->prefix . 'coco_rulesets';
$rulesets = $wpdb->get_results("SELECT * FROM $table_rulesets ORDER BY created_at DESC");

if ($rulesets) {
    foreach ($rulesets as $ruleset) {
        echo "<p><strong>{$ruleset->name}</strong> (v{$ruleset->version}) - Active: " . ($ruleset->active ? 'Yes' : 'No') . "</p>";
    }
} else {
    echo '<p class="error">No rulesets found</p>';
}

echo '<hr>';
echo '<p style="color: #666; font-size: 12px;">Delete this file after checking.</p>';
?>
