# Venue Management Update

## What Was Fixed

### Issue 1: "Add Venue" Button Not Working
**Problem**: Clicking "Add Venue" in Settings did nothing.

**Solution**: Removed manual venue management. Venues are now **automatically pulled from The Events Calendar**.

### Issue 2: Hardcoded Venue List
**Problem**: The event filter showed 3 hardcoded venues (Twnty7, Minories, Haus).

**Solution**: Venues now load dynamically from your The Events Calendar plugin.

---

## How Venues Work Now

### Automatic Detection
The plugin automatically reads venues from The Events Calendar's `tribe_events_venue` taxonomy. No manual configuration needed!

### Where Venues Appear
1. **Events Page** - Filter dropdown shows all your venues
2. **Settings Page** - Display-only table showing venue information
3. **Event Data** - Each event automatically inherits its venue from The Events Calendar

### What Gets Pulled Automatically
- Venue name
- Venue slug
- Number of events at each venue
- Venue capacity (from event's _EventCapacity meta field)

---

## Changes Made

### New REST API Endpoint
**GET** `/wp-json/coco-ops/v1/venues`

Returns all venues from The Events Calendar:
```json
[
  {
    "id": 123,
    "name": "Twnty7",
    "slug": "twnty7",
    "count": 45
  },
  {
    "id": 124,
    "name": "Minories",
    "slug": "minories", 
    "count": 32
  }
]
```

### Updated Files
1. **includes/class-rest-api.php**
   - Added `get_venues()` method
   - Queries `tribe_events_venue` taxonomy

2. **assets/js/admin-app.js**
   - Added `API.getVenues()` method
   - Updated `eventsList` component to load venues
   - Updated `forecastDashboard` component to load venues
   - Updated `settingsManager` component to load venues
   - Removed `addVenue()` and `removeVenue()` functions

3. **templates/admin-pages/events-list.php**
   - Changed hardcoded venue options to dynamic Alpine.js loop
   - Venue dropdown now shows: "Venue Name (event count)"

4. **templates/admin-pages/settings.php**
   - Removed venue add/edit/remove UI
   - Now shows read-only table of venues from The Events Calendar
   - Added helpful tip about capacity management

---

## Benefits

✅ **Zero Configuration** - Works out of the box with your existing venues  
✅ **Always In Sync** - Venues update automatically when you add/edit in The Events Calendar  
✅ **No Duplication** - Single source of truth (The Events Calendar)  
✅ **Cleaner UI** - Simpler settings page without complex forms  

---

## Do You Need to Configure Venues?

**No!** The system works automatically with any venues you have in The Events Calendar.

### Optional: Set Event Capacity
If you want accurate capacity for forecasting:
1. Go to The Events Calendar → Edit Event
2. Find the "Capacity" field
3. Enter max capacity for that specific event

The plugin will use this when calculating staffing and forecasting.

---

## Testing

After the update, verify:

1. **Events Page**
   - Open "Ops Forecast → Events"
   - Click the "Venue" dropdown
   - You should see all your venues from The Events Calendar

2. **Settings Page**
   - Open "Ops Forecast → Settings"
   - Scroll to "Venues" section
   - You should see a table with all your venues

3. **Forecast Dashboard**
   - Select any event
   - Venue information should display correctly

---

## If No Venues Appear

Check these:
1. **The Events Calendar is active** - Plugin dependency
2. **You have venues created** - Go to Events → Venues in WP admin
3. **Venues have events** - At least one event should be assigned to each venue
4. **Browser console** - Look for JavaScript errors (F12 → Console tab)

---

## Migration Notes

If you previously tried to add venues manually (before this update):
- Those manual entries are no longer used
- Settings now only store: snapshot times, cohort sensitivity, forecasting toggle
- All venue data comes directly from The Events Calendar

No data loss - the plugin just references venues differently now!

---

## Support

If venues still don't appear:
1. Check browser console for errors
2. Verify The Events Calendar plugin is active
3. Try creating a test venue in The Events Calendar
4. Reload the Ops Forecast page

The system is now simpler and more reliable! 🎯

