# Troubleshooting Guide - Ops Forecast Plugin

## Common Issues & Solutions

### 1. Events Page Shows "No events found"

**Symptoms:**
- Events page is empty
- Venue dropdown is empty
- No events in the table

**Causes & Solutions:**

#### A. The Events Calendar Plugin Not Active
**Check:** Go to Plugins → Installed Plugins
**Solution:** Activate "The Events Calendar" plugin

#### B. No Events Created
**Check:** Go to Events → All Events in WordPress admin
**Solution:** Create at least one event with:
- Future start date
- Published status
- Assigned venue

#### C. Events Have No Start Date
**Check:** Edit an event, look for "Event Start Date" field
**Solution:** Set a future start date for your events

#### D. Events Not Assigned to Venues
**Check:** Edit an event, look for "Venue" field
**Solution:** Assign each event to a venue

### 2. Venue Dropdown Empty

**Symptoms:**
- "All Venues" is the only option
- No venues appear in filter

**Solutions:**

#### A. Create Venues in The Events Calendar
1. Go to Events → Venues
2. Click "Add New Venue"
3. Enter venue name (e.g., "Twnty7")
4. Save venue
5. Assign events to venues

#### B. Check Venue Assignment
1. Edit each event
2. Find "Venue" field
3. Select a venue from dropdown
4. Save event

### 3. Forecast Dashboard Shows "No events"

**Symptoms:**
- Event selector dropdown is empty
- "Choose an event" is only option

**Solution:** Same as Issue #1 - ensure you have events with venues

### 4. Settings Page - No Save Button

**Symptoms:**
- Can't save settings
- No save button visible

**Solution:** The save button IS there! Look for:
- Blue button at bottom: "💾 Save Settings"
- It's in the gray box at the bottom of the page

### 5. Capacity Settings Confusion

**Question:** "Where do I set event capacity?"

**Answer:** In The Events Calendar, NOT in Ops Forecast:

1. **Edit an Event:**
   - Go to Events → All Events
   - Click "Edit" on any event
   - Look for "Capacity" field
   - Enter max number of guests (e.g., 500)

2. **Set Default Venue Capacity:**
   - Go to Events → Settings → Venues
   - Edit each venue
   - Set default capacity

### 6. JavaScript Errors

**Symptoms:**
- Page loads but nothing works
- Console shows errors

**Debug Steps:**
1. Press F12 to open browser console
2. Look for red error messages
3. Check if Alpine.js is loading
4. Verify REST API endpoints work

**Common Errors:**
- `Alpine is not defined` → Alpine.js not loading
- `API.getEvents is not a function` → JavaScript file not loading
- `404 Not Found` → REST API endpoints not working

### 7. REST API Issues

**Test API Endpoints:**

1. **Test Events:** 
   ```
   /wp-json/coco-ops/v1/events
   ```

2. **Test Venues:**
   ```
   /wp-json/coco-ops/v1/venues
   ```

3. **Test Settings:**
   ```
   /wp-json/coco-ops/v1/settings
   ```

**If 404 errors:**
- Check if plugin is activated
- Go to Settings → Permalinks → Save Changes
- Check .htaccess file permissions

### 8. Database Issues

**Check Tables Created:**
1. Go to phpMyAdmin or database tool
2. Look for tables starting with `wp_coco_`
3. Should see 6 tables:
   - `wp_coco_event_features`
   - `wp_coco_event_snapshots`
   - `wp_coco_event_planning`
   - `wp_coco_staffing_recs`
   - `wp_coco_event_actuals`
   - `wp_coco_rulesets`

**If tables missing:**
- Deactivate and reactivate plugin
- Check database user has CREATE TABLE permission

### 9. Cron Job Issues

**Check if Snapshots Running:**
1. Go to Settings → Maintenance
2. Click "Run Snapshots Now"
3. Check if events appear in database

**Manual Cron Test:**
```bash
wp cron event run coco_ops_snapshot_cron
```

### 10. Permission Issues

**Check User Capabilities:**
- User needs `coco_ops_view` capability
- Administrators get this automatically
- Other roles need manual assignment

## Quick Diagnostic Checklist

### ✅ Plugin Setup
- [ ] Plugin activated in WordPress
- [ ] No PHP errors in error logs
- [ ] Database tables created (6 tables)
- [ ] Admin menu appears

### ✅ Dependencies
- [ ] The Events Calendar plugin active
- [ ] Event Tickets Plus plugin active (for ticket sales)
- [ ] WooCommerce plugin active (for table sales)

### ✅ Content Setup
- [ ] At least 1 venue created in The Events Calendar
- [ ] At least 1 published event with future start date
- [ ] Event assigned to venue
- [ ] Event has start date set

### ✅ Technical
- [ ] REST API endpoints return data
- [ ] JavaScript console shows no errors
- [ ] Alpine.js components initialize
- [ ] Save button works in Settings

## Still Having Issues?

### Debug Mode
Add this to wp-config.php for detailed error messages:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

### Check Error Logs
- WordPress: `/wp-content/debug.log`
- Server: Check your hosting control panel
- Browser: F12 → Console tab

### Contact Support
If issues persist:
1. Check browser console for JavaScript errors
2. Check WordPress error logs
3. Verify all plugin dependencies are active
4. Test with a fresh WordPress installation

## Expected Behavior

### Events Page
- Shows table of upcoming events
- Venue dropdown populated with your venues
- Filters work (venue, date range, status)
- "Plan" and "Actuals" buttons work

### Settings Page
- Shows your venues from The Events Calendar
- Save button at bottom works
- Settings persist after saving

### Forecast Dashboard
- Event selector shows your events
- Selecting event shows forecast data (after snapshots run)

The plugin should work out-of-the-box once you have events in The Events Calendar! 🎯
