# Sorting and Forecast Dashboard Fixes

## Issues Fixed

### 1. Events Sorting ✅
**Problem:** Events were grouped by venue instead of sorted by date
**Solution:** Changed query to sort by `_EventStartDate` meta field

**Before:**
```php
'orderby' => 'date',  // WordPress post date
'order' => 'ASC'
```

**After:**
```php
'orderby' => 'meta_value',
'meta_key' => '_EventStartDate',  // Event start date
'order' => 'ASC'
```

### 2. Forecast Dashboard Empty Dropdown ✅
**Problem:** Forecast dashboard wasn't loading events properly
**Solution:** Fixed API call to use clean filters and added debug logging

**Before:**
```javascript
this.events = await API.getEvents();  // Sent null filters
```

**After:**
```javascript
this.events = await API.getEvents({});  // Clean empty object
```

## What Should Work Now

### ✅ Events Page
- Events sorted by actual event start date (not post creation date)
- Chronological order from earliest to latest
- No more venue grouping

### ✅ Forecast Dashboard
- Event dropdown should populate with events
- Events should show as "Event Name - Date"
- Console should show debug logs

## Test Steps

### 1. Test Events Sorting
1. Go to **Ops Forecast → Events**
2. Check that events are in chronological order by date
3. Should see earliest events first, latest last

### 2. Test Forecast Dashboard
1. Go to **Ops Forecast → Forecast**
2. Open browser console (F12)
3. Look for logs:
   ```
   🔍 Forecast Dashboard: Loading events...
   📊 Forecast Dashboard: Loaded X events
   ```
4. Event dropdown should show events like:
   - "Event Name - 25 Oct 2025"
   - "Another Event - 26 Oct 2025"

### 3. If Forecast Still Empty
Check console for:
- ❌ "Failed to load events" → API issue
- ❌ "Loaded 0 events" → No events returned
- ✅ "Loaded X events" but dropdown empty → Template issue

## Expected Results

### Events Page
- ✅ Chronological sorting by event date
- ✅ All events visible
- ✅ Venue filter works
- ✅ Date range filter works

### Forecast Dashboard
- ✅ Event dropdown populated
- ✅ Can select events
- ✅ Shows event details when selected
- ✅ Debug logs in console

## Why This Happened

### Sorting Issue
WordPress `tribe_events` posts have their actual event date stored in `_EventStartDate` meta field, not the post creation date. Sorting by `date` was using post creation time.

### Forecast Dashboard Issue
The `API.getEvents()` call was sending `has_actuals=null` as a string, which was filtering out all events. The clean filter logic now excludes null values entirely.

## Debug Information

If forecast dashboard still shows empty dropdown:

1. **Check console logs** - Should see event loading messages
2. **Check API response** - Should see events in the response
3. **Check template** - Make sure `x-for="event in events"` is working

The debug logs will show exactly what's happening with the forecast dashboard event loading! 🎯
