# Coco Ops Forecast & Staffing Recommender

Version: 1.0.0

## Overview

A WordPress operations intelligence plugin built for Cococure's multi-venue group. It helps managers forecast attendance and recommend staffing levels using historical data, ticket sales tracking, and cohort-based forecasting.

## Key Features

- **Dual Forecasting Modes**: Manual estimates (immediate use) + Automated forecasts (improves over time)
- **5 Staff Roles**: Security, Bartenders, Bottle Girls, Wait Staff, Managers
- **Automated Snapshots**: Twice-daily capture of ticket/table sales data
- **Cohort Forecasting**: Statistical predictions based on similar past events
- **Pacing Analysis**: Compare current sales velocity to historical patterns
- **YAML Rules Engine**: Flexible, versioned staffing calculation formulas
- **Variance Tracking**: Learn from differences between forecasts and actuals

## Installation

1. Upload the `coco-ops-forecast` folder to `/wp-content/plugins/`
2. Activate the plugin through the WordPress admin panel
3. Navigate to **Ops Forecast** in the admin menu
4. Start by entering past event actuals to build your dataset

## Requirements

- WordPress 5.8+
- PHP 7.4+
- The Events Calendar plugin
- Event Tickets Plus plugin
- WooCommerce (for table sales tracking)

## Database Tables

The plugin creates 6 custom tables:

1. `wp_coco_event_features` - Event metadata and characteristics
2. `wp_coco_event_snapshots` - Twice-daily sales tracking
3. `wp_coco_event_planning` - Manual estimates and forecast toggles
4. `wp_coco_staffing_recs` - Computed staffing recommendations
5. `wp_coco_event_actuals` - Post-event actual data
6. `wp_coco_rulesets` - YAML staffing calculation rules

## Admin Pages

### 1. Events Dashboard
- View all upcoming events
- Filter by venue, date range, or actuals status
- Quick access to planning and actuals entry
- Real-time sales data display

### 2. Forecast Dashboard
- Select event to view detailed forecast
- Current sales vs cohort median (pacing analysis)
- Sales velocity charts
- Confidence intervals and cohort information
- Recommended staffing breakdown

### 3. Rules Manager
- View active YAML ruleset
- Create new rule versions
- Activate different rulesets
- Version history tracking

### 4. Settings
- Configure venues (name, capacity, default timeband)
- Adjust snapshot schedule
- Set cohort matching sensitivity
- Enable/disable automated forecasting
- Manual snapshot trigger

### 5. About
- Plugin documentation
- Feature overview
- Technical details

## How It Works

### Stage 1: Manual Planning
1. Manager enters expected attendance
2. System applies YAML rules to calculate staffing
3. Results show with detailed rationale
4. Save plan for the event

### Stage 2: Actuals Entry
1. After event concludes, enter actual attendance
2. Record actual staff used for each role
3. Add revenue and notes
4. Lock entry to prevent accidental changes

### Stage 3: Automated Snapshots
1. Cron job runs twice daily (10am, 6pm)
2. Captures current ticket/table sales for all upcoming events
3. Calculates days-to-event
4. Stores snapshot in database

### Stage 4: Cohort Forecasting
1. System finds similar past events (same venue, weekday, timeband)
2. Analyzes their sales patterns at the same D-X point
3. Calculates p50 (median) forecast with confidence intervals
4. Shows pacing: how current event compares to cohort median
5. Auto-updates staffing recommendations

## YAML Rules Structure

```yaml
version: "1.0.0"
rules:
  security:
    base_ratio: 75        # 1 staff per 75 guests
    floor: 2              # Minimum staff
    cap: 15               # Maximum staff
    weekend_modifier: 1.15
  bartenders:
    base_ratio: 40
    floor: 3
    cap: 20
    friday_saturday_modifier: 1.2
  bottle_girls:
    base_ratio: 100
    floor: 1
    cap: 8
    late_night_modifier: 1.3
  wait_staff:
    base_ratio: 60
    floor: 2
    cap: 12
    weekend_modifier: 1.1
  managers:
    base_ratio: 200
    floor: 1
    cap: 4
```

## REST API Endpoints

All endpoints use namespace: `/wp-json/coco-ops/v1/`

### Events
- `GET /events` - List all events (with filters)
- `GET /events/{id}` - Get single event details
- `GET /events/{id}/snapshots` - Get event snapshots
- `GET /events/{id}/cohorts` - Get cohort events
- `GET /events/{id}/forecast` - Get forecast data
- `POST /events/{id}/compute-staffing` - Compute staffing
- `POST /events/{id}/save-plan` - Save planning data
- `POST /events/{id}/save-actuals` - Save actuals data

### Rulesets
- `GET /rulesets` - List all rulesets
- `POST /rulesets` - Create new ruleset
- `POST /rulesets/{id}/activate` - Activate ruleset

### Settings
- `GET /settings` - Get settings
- `POST /settings` - Save settings

## User Capabilities

- `coco_ops_view` - View pages and read data
- `coco_ops_admin` - Full access (edit rules, settings, save data)

Automatically granted to administrators on activation.

## Cron Schedule

- **Hook**: `coco_ops_snapshot_cron`
- **Schedule**: Twice daily (every 12 hours)
- **Function**: Captures ticket/table sales for all upcoming events

To manually trigger: Go to Settings → Maintenance → Run Snapshots Now

## Recommended Workflow

1. **Week 1-2**: Enter past event actuals (3-6 weeks of historical data)
2. **Week 3-4**: Use manual mode for planning, let snapshots collect data
3. **Week 5-6**: Review forecast dashboard, verify cohort predictions
4. **Week 7+**: Switch to auto forecast mode for reliable forecasts
5. **Monthly**: Review accuracy, adjust YAML rules if needed

## Development

### Frontend Stack
- Alpine.js 3.13 (reactive UI)
- Tailwind CSS 3.4 (styling)
- Chart.js 4.4 (data visualization)

### Backend Classes
- `Coco_Ops_Database` - Table management
- `Coco_Ops_Rules_Engine` - YAML parsing and staffing calculations
- `Coco_Ops_Cohort_Matcher` - Find similar events
- `Coco_Ops_Forecasting_Engine` - Statistical predictions
- `Coco_Ops_Snapshot_Cron` - Automated data collection
- `Coco_Ops_REST_API` - Endpoints and data access

## Troubleshooting

### Snapshots not running
- Check cron is configured: `wp cron event list`
- Manually trigger from Settings page
- Verify The Events Calendar has upcoming events

### No cohorts found
- Need at least 3 similar past events with actuals
- Reduce cohort sensitivity in Settings
- Ensure venue_id matches between events

### Forecast shows fallback
- Not enough historical data yet
- Keep entering actuals, system will improve
- Check cohort matching criteria

## Future Enhancements

- OpenAI API integration for nuanced recommendations
- Budget forecasting (staff cost projections)
- Mobile dashboard app
- POS integration for real-time revenue
- Anomaly detection alerts
- Weather integration
- Multi-currency support

## Support

For questions or issues:
- Email: tech@cococure.co.uk
- In-app: About page → Contact Support

## License

Proprietary - Cococure Ltd. All rights reserved.

