# Quick Authentication Fix

## Run the Debug Script First

Visit this URL in your browser (while logged in):
```
https://your-site.com/wp-content/plugins/coco-ops-forecast/debug-auth.php
```

This will show you:
- If you're logged in
- Your current capabilities
- Whether the REST API works when called directly from PHP
- Any specific error messages

## Temporary Fix to Bypass Permissions

If the debug shows you ARE logged in but still getting 401 errors, add this to the top of `/wp-content/plugins/coco-ops-forecast/includes/class-rest-api.php` right after the `class Coco_Ops_Forecast_REST_API {` line:

Find this line (around line 10):
```php
class Coco_Ops_Forecast_REST_API {
```

And change the permission callback methods to this:
```php
public function check_permission() {
    return true; // Temporary - allows all logged-in users
}

public function check_admin_permission() {
    return true; // Temporary - allows all logged-in users
}
```

**WARNING:** This removes all permission checks. Only use temporarily for debugging!

## If That Works

If bypassing permissions makes it work, then we know:
1. The REST API routes are registered correctly
2. The data is being fetched correctly
3. The issue is purely with permission callbacks

Then we can implement proper permission checks based on what the debug script shows.

## Alternative: Cookie Authentication Issue

WordPress REST API requires cookie authentication + nonce for logged-in users. The issue might be:

### Option 1: Ensure cookies are being sent
Add this to `assets/js/admin-app.js` in the `request` method:

```javascript
const config = {
    ...options,
    credentials: 'same-origin', // Add this line
    headers: { ...headers, ...options.headers }
};
```

### Option 2: Use a different authentication method
For admin pages, we can rely on the fact that the user is already authenticated in WordPress admin.

## Most Likely Issue

Based on the 401 error, WordPress isn't recognizing the authenticated user when the REST API call is made. This could be:

1. **Nonce mismatch** - The nonce isn't being validated correctly
2. **Cookie issue** - Cookies aren't being sent with fetch requests
3. **Permission callback issue** - The permission check is failing even for admins

Run the debug script to see which one it is!

## Quick Test

After running debug-auth.php, try clicking the API links it provides. If those work in the browser but not from JavaScript, it's a cookie/nonce issue with the fetch request.

Delete both debug files after fixing:
- `debug-auth.php`
- `fix-permissions.php`

